function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'com/simibubi/create/content/contraptions/components/actors/BlockBreakingMovementBehaviour',
		'methodName' : 'onBlockBroken', 
		'methodDesc' : '(Lcom/simibubi/create/content/contraptions/components/structureMovement/MovementContext;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V'
	}

	var world = {
		'class' : 'com/simibubi/create/content/contraptions/components/structureMovement/MovementContext',
		'fieldName' : 'world',
		'fieldDesc' : 'Lnet/minecraft/world/level/Level;'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onBlockBroken',
		'methodDesc' : '(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V'
	}

	var instructions = [ 
		insnLoadObj(1, "context"),
		insnGetField(world),
		insnLoadObj(2, "pos"),
		insnLoadObj(3, "state"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBeforeAll(method, instructions);
				return method;
			}
		}
	}
}