/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.zen.category;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.jeitweaker.bridge.JeiCategoryPluginBridge;
import com.blamejared.jeitweaker.helper.category.JeiCategoryHelper;
import com.blamejared.jeitweaker.zen.component.JeiDrawable;
import com.blamejared.jeitweaker.zen.component.RawJeiIngredient;
import com.blamejared.jeitweaker.zen.recipe.JeiRecipe;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Logger;
import org.openzen.zencode.java.ZenCodeType;

@Document(value="mods/JEITweaker/API/Category/JeiCategory")
@ZenCodeType.Name(value="mods.jei.category.JeiCategory")
@ZenRegister(modDeps={"jei"})
public interface JeiCategory {
    @ZenCodeType.Method
    public static <T extends JeiCategory> JeiCategory create(Class<T> typeToken, String id, Component name, JeiDrawable icon, RawJeiIngredient[] catalysts) {
        return JeiCategory.create(typeToken, id, name, icon, catalysts, ignore -> {});
    }

    @ZenCodeType.Method
    public static <T extends JeiCategory> JeiCategory create(Class<T> typeToken, String id, Component name, JeiDrawable icon, RawJeiIngredient[] catalysts, Consumer<T> configurator) {
        return JeiCategoryHelper.of(typeToken, id, name, icon, catalysts, configurator);
    }

    @ZenCodeType.Getter(value="id")
    public ResourceLocation id();

    @ZenCodeType.Getter(value="name")
    public Component name();

    @ZenCodeType.Getter(value="icon")
    public JeiDrawable icon();

    @ZenCodeType.Getter(value="background")
    public JeiDrawable background();

    @ZenCodeType.Getter(value="catalysts")
    public RawJeiIngredient[] catalysts();

    public void addRecipe(JeiRecipe var1);

    public List<JeiRecipe> getTargetRecipes();

    default public BiPredicate<JeiRecipe, Logger> getRecipeValidator() {
        return (recipe, logger) -> true;
    }

    public Supplier<JeiCategoryPluginBridge> getBridgeCreator();
}

