/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.zen.category;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.jeitweaker.bridge.CustomRecipeCategoryBridge;
import com.blamejared.jeitweaker.bridge.JeiCategoryPluginBridge;
import com.blamejared.jeitweaker.zen.category.SimpleJeiCategory;
import com.blamejared.jeitweaker.zen.component.JeiDrawable;
import com.blamejared.jeitweaker.zen.component.RawJeiIngredient;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@Document(value="mods/JEITweaker/API/Category/Custom")
@ZenCodeType.Name(value="mods.jei.category.Custom")
@ZenRegister(modDeps={"jei"})
public final class CustomRecipeCategory
extends SimpleJeiCategory {
    private final Int2ObjectMap<SlotData> slots = new Int2ObjectRBTreeMap();
    private final List<DrawableData> drawables = new ArrayList<DrawableData>();
    private final List<TextData> tooltips = new ArrayList<TextData>();
    private final List<TextData> textAreas = new ArrayList<TextData>();
    private JeiDrawable background = null;
    private boolean canBeShapeless = false;

    public CustomRecipeCategory(ResourceLocation id, Component name, JeiDrawable icon, RawJeiIngredient ... catalysts) {
        super(id, name, icon, catalysts);
    }

    @ZenCodeType.Setter(value="background")
    public void setBackground(JeiDrawable background) {
        this.background = background;
    }

    @ZenCodeType.Setter(value="canHaveShapelessMarker")
    public void setCanHaveShapelessMarker(boolean canHaveShapelessMarker) {
        this.canBeShapeless = canHaveShapelessMarker;
    }

    @ZenCodeType.Method(value="addSlot")
    public void addSlot(int index, int x, int y, boolean isInput) {
        if (this.slots.get(index) != null) {
            throw new IllegalArgumentException("Slot index " + index + " was already registered");
        }
        this.slots.put(index, (Object)SlotData.of(index, x, y, isInput));
    }

    @ZenCodeType.Method(value="addDrawable")
    public void addDrawable(int x, int y, JeiDrawable drawable) {
        this.drawables.add(DrawableData.of(drawable, x, y));
    }

    @ZenCodeType.Method(value="addTooltip")
    public void addTooltip(int x, int y, int w, int h, Component ... text) {
        this.tooltips.add(TextData.of(x, y, w, h, Collections.unmodifiableList(Arrays.asList(text))));
    }

    @ZenCodeType.Method(value="addText")
    public void addText(int x, int y, Component text) {
        this.textAreas.add(TextData.of(x, y, -1, -1, Collections.singletonList(text)));
    }

    @Override
    public JeiDrawable background() {
        return Objects.requireNonNull(this.background, "Background was not set");
    }

    @Override
    public Supplier<JeiCategoryPluginBridge> getBridgeCreator() {
        return () -> new CustomRecipeCategoryBridge(Collections.unmodifiableCollection(this.slots.values()), Collections.unmodifiableCollection(this.drawables), Collections.unmodifiableCollection(this.tooltips), Collections.unmodifiableCollection(this.textAreas), this.canBeShapeless);
    }

    public static final class SlotData {
        private final int index;
        private final Coordinates coordinates;
        private final boolean input;

        private SlotData(int index, Coordinates coordinates, boolean input) {
            this.index = index;
            this.coordinates = coordinates;
            this.input = input;
        }

        private static SlotData of(int index, int x, int y, boolean input) {
            if (index < 0) {
                throw new IllegalArgumentException("Unable to create slot with index " + index + " because it's negative");
            }
            return new SlotData(index, Coordinates.of(x, y), input);
        }

        public int index() {
            return this.index;
        }

        public Coordinates coordinates() {
            return this.coordinates;
        }

        public boolean isInput() {
            return this.input;
        }
    }

    public static final class DrawableData {
        private final JeiDrawable drawable;
        private final Coordinates coordinates;

        private DrawableData(JeiDrawable drawable, Coordinates coordinates) {
            this.drawable = drawable;
            this.coordinates = coordinates;
        }

        private static DrawableData of(JeiDrawable drawable, int x, int y) {
            Objects.requireNonNull(drawable, "Drawable must not be null");
            return new DrawableData(drawable, Coordinates.of(x, y));
        }

        public JeiDrawable drawable() {
            return this.drawable;
        }

        public Coordinates coordinates() {
            return this.coordinates;
        }
    }

    public static final class TextData {
        private final Coordinates topLeft;
        private final Coordinates activeArea;
        private final List<Component> text;

        private TextData(Coordinates topLeft, Coordinates activeArea, List<Component> text) {
            this.topLeft = topLeft;
            this.activeArea = activeArea;
            this.text = text;
        }

        private static TextData of(int x, int y, int w, int h, List<Component> text) {
            Objects.requireNonNull(text, "No text specified");
            return new TextData(Coordinates.of(x, y), w < 0 && h < 0 ? null : Coordinates.of(w, h), text);
        }

        public Coordinates topLeft() {
            return this.topLeft;
        }

        public Coordinates activeArea() {
            return this.activeArea;
        }

        public List<Component> text() {
            return this.text;
        }
    }

    public static final class Coordinates {
        private final int x;
        private final int y;

        private Coordinates(int x, int y) {
            this.x = x;
            this.y = y;
        }

        private static Coordinates of(int x, int y) {
            if (x < 0 || y < 0) {
                throw new IllegalArgumentException("Coordinates (" + x + ", " + y + ") are out of bounds");
            }
            return new Coordinates(x, y);
        }

        public int x() {
            return this.x;
        }

        public int y() {
            return this.y;
        }
    }
}

