/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.zen;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.jeitweaker.actions.ActionAddInfo;
import com.blamejared.jeitweaker.actions.ActionAddIngredient;
import com.blamejared.jeitweaker.actions.ActionAddRecipeCategory;
import com.blamejared.jeitweaker.actions.ActionHideCategory;
import com.blamejared.jeitweaker.actions.ActionHideIngredient;
import com.blamejared.jeitweaker.actions.ActionHideMod;
import com.blamejared.jeitweaker.actions.ActionHideRecipe;
import com.blamejared.jeitweaker.actions.ActionHideRegex;
import com.blamejared.jeitweaker.zen.category.JeiCategory;
import com.blamejared.jeitweaker.zen.component.RawJeiIngredient;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@Document(value="mods/JEITweaker/API/JEI")
@ZenCodeType.Name(value="mods.jei.JEI")
@ZenRegister(modDeps={"jei"})
public final class JeiManager {
    @ZenCodeType.Method
    public static void addCategory(JeiCategory category) {
        CraftTweakerAPI.apply((IAction)new ActionAddRecipeCategory(category));
    }

    @ZenCodeType.Method
    public static void addDescription(RawJeiIngredient ingredient, Component ... description) {
        CraftTweakerAPI.apply(new ActionAddInfo(ingredient.cast(), description));
    }

    @ZenCodeType.Method
    public static void addIngredient(RawJeiIngredient ingredient) {
        CraftTweakerAPI.apply(new ActionAddIngredient(ingredient.cast()));
    }

    @ZenCodeType.Method
    public static void hideCategory(String category) {
        CraftTweakerAPI.apply((IAction)new ActionHideCategory(new ResourceLocation(category)));
    }

    @ZenCodeType.Method
    public static void hideIngredient(RawJeiIngredient ingredient) {
        CraftTweakerAPI.apply(new ActionHideIngredient(ingredient.cast()));
    }

    @ZenCodeType.Method
    public static void hideMod(String modId, @ZenCodeType.Optional(value="(name as string) => {return false;}") Predicate<String> exclude) {
        CraftTweakerAPI.apply((IAction)new ActionHideMod(modId, exclude));
    }

    @ZenCodeType.Method
    public static void hideRecipe(String categoryId, String recipeName) {
        CraftTweakerAPI.apply((IAction)new ActionHideRecipe(new ResourceLocation(categoryId), new ResourceLocation(recipeName)));
    }

    @ZenCodeType.Method
    public static void hideRegex(String regex) {
        CraftTweakerAPI.apply((IAction)new ActionHideRegex(regex));
    }
}

