/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiTextFieldDouble;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.GuiTextFieldInteger;
import fi.dy.masa.malilib.gui.MaLiLibIcons;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import fi.dy.masa.malilib.interfaces.ICoordinateValueModifier;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.malilib.util.StringUtils;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;

public class GuiUtils {
    public static int getScaledWindowWidth() {
        return Minecraft.m_91087_().m_91268_().m_85445_();
    }

    public static int getScaledWindowHeight() {
        return Minecraft.m_91087_().m_91268_().m_85446_();
    }

    public static int getDisplayWidth() {
        return Minecraft.m_91087_().m_91268_().m_85443_();
    }

    public static int getDisplayHeight() {
        return Minecraft.m_91087_().m_91268_().m_85444_();
    }

    @Nullable
    public static Screen getCurrentScreen() {
        return Minecraft.m_91087_().f_91080_;
    }

    public static void createBlockPosInputsVertical(int x, int y, int textFieldWidth, BlockPos pos, ICoordinateValueModifier modifier, boolean addButton, GuiBase gui) {
        GuiUtils.createBlockPosInput(x, y, textFieldWidth, PositionUtils.CoordinateType.X, pos, modifier, addButton, gui);
        GuiUtils.createBlockPosInput(x, y + 17, textFieldWidth, PositionUtils.CoordinateType.Y, pos, modifier, addButton, gui);
        GuiUtils.createBlockPosInput(x, y + 34, textFieldWidth, PositionUtils.CoordinateType.Z, pos, modifier, addButton, gui);
    }

    public static void createVec3dInputsVertical(int x, int y, int textFieldWidth, Vec3 pos, ICoordinateValueModifier modifier, boolean addButton, GuiBase gui) {
        GuiUtils.createVec3dInput(x, y, textFieldWidth, PositionUtils.CoordinateType.X, pos, modifier, addButton, gui);
        GuiUtils.createVec3dInput(x, y + 17, textFieldWidth, PositionUtils.CoordinateType.Y, pos, modifier, addButton, gui);
        GuiUtils.createVec3dInput(x, y + 34, textFieldWidth, PositionUtils.CoordinateType.Z, pos, modifier, addButton, gui);
    }

    public static void createBlockPosInput(int x, int y, int textFieldWidth, PositionUtils.CoordinateType type, BlockPos pos, ICoordinateValueModifier modifier, boolean addButton, GuiBase gui) {
        x = GuiUtils.addLabel(x, y, type, gui);
        GuiTextFieldInteger textField = new GuiTextFieldInteger(x, y + 1, textFieldWidth, 14, Minecraft.m_91087_().f_91062_);
        textField.m_94144_(GuiUtils.getCoordinateValueString(type, pos));
        GuiUtils.addTextFieldAndButton(x + textFieldWidth + 4, y, type, modifier, textField, addButton, gui);
    }

    public static void createVec3dInput(int x, int y, int textFieldWidth, PositionUtils.CoordinateType type, Vec3 pos, ICoordinateValueModifier modifier, boolean addButton, GuiBase gui) {
        x = GuiUtils.addLabel(x, y, type, gui);
        GuiTextFieldDouble textField = new GuiTextFieldDouble(x, y + 1, textFieldWidth, 14, Minecraft.m_91087_().f_91062_);
        textField.m_94144_(GuiUtils.getCoordinateValueString(type, pos));
        GuiUtils.addTextFieldAndButton(x + textFieldWidth + 4, y, type, modifier, textField, addButton, gui);
    }

    protected static void addTextFieldAndButton(int x, int y, PositionUtils.CoordinateType type, ICoordinateValueModifier modifier, GuiTextFieldGeneric textField, boolean addButton, GuiBase gui) {
        gui.addTextField(textField, new TextFieldListenerCoordinateInput(type, modifier));
        if (addButton) {
            String hover = StringUtils.translate("malilib.gui.button.hover.plus_minus_tip", new Object[0]);
            ButtonGeneric button = new ButtonGeneric(x, y, MaLiLibIcons.BTN_PLUSMINUS_16, hover);
            gui.addButton(button, new ButtonListenerCoordinateInput(type, modifier));
        }
    }

    public static String getCoordinateValueString(PositionUtils.CoordinateType type, BlockPos pos) {
        switch (type) {
            case X: {
                return String.valueOf(pos.m_123341_());
            }
            case Y: {
                return String.valueOf(pos.m_123342_());
            }
            case Z: {
                return String.valueOf(pos.m_123343_());
            }
        }
        return "";
    }

    public static String getCoordinateValueString(PositionUtils.CoordinateType type, Vec3 pos) {
        switch (type) {
            case X: {
                return String.valueOf(pos.f_82479_);
            }
            case Y: {
                return String.valueOf(pos.f_82480_);
            }
            case Z: {
                return String.valueOf(pos.f_82481_);
            }
        }
        return "";
    }

    protected static int addLabel(int x, int y, PositionUtils.CoordinateType type, GuiBase gui) {
        String label = type.name() + ":";
        int labelWidth = 0;
        for (PositionUtils.CoordinateType t : PositionUtils.CoordinateType.values()) {
            labelWidth = Math.max(labelWidth, StringUtils.getStringWidth(t.name() + ":") + 4);
        }
        gui.addLabel(x, y, labelWidth, 20, -1, label);
        return x += labelWidth;
    }

    public static class TextFieldListenerCoordinateInput
    implements ITextFieldListener<GuiTextFieldGeneric> {
        protected final ICoordinateValueModifier modifier;
        protected final PositionUtils.CoordinateType type;

        public TextFieldListenerCoordinateInput(PositionUtils.CoordinateType type, ICoordinateValueModifier modifier) {
            this.modifier = modifier;
            this.type = type;
        }

        @Override
        public boolean onTextChange(GuiTextFieldGeneric textField) {
            this.modifier.setValueFromString(this.type, textField.m_94155_());
            return false;
        }
    }

    public static class ButtonListenerCoordinateInput
    implements IButtonActionListener {
        protected final ICoordinateValueModifier modifier;
        protected final PositionUtils.CoordinateType type;

        public ButtonListenerCoordinateInput(PositionUtils.CoordinateType type, ICoordinateValueModifier modifier) {
            this.modifier = modifier;
            this.type = type;
        }

        @Override
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            int amount;
            int n = amount = mouseButton == 1 ? -1 : 1;
            if (GuiBase.isShiftDown()) {
                amount *= 8;
            }
            if (GuiBase.isAltDown()) {
                amount *= 4;
            }
            this.modifier.modifyValue(this.type, amount);
        }

        public static enum Type {
            NUDGE_COORD_X,
            NUDGE_COORD_Y,
            NUDGE_COORD_Z;

        }
    }
}

