/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.widgets;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import fi.dy.masa.malilib.config.IConfigInteger;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiColorEditorHSV;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.function.IntConsumer;

public class WidgetColorIndicator
extends WidgetBase {
    protected final IConfigInteger config;
    protected final ImmutableList<String> hoverText;

    public WidgetColorIndicator(int x, int y, int width, int height, Color4f color, IntConsumer consumer) {
        this(x, y, width, height, new ConfigInteger("", color.intValue, ""));
        ((ConfigInteger)this.config).setValueChangeCallback(cfg -> consumer.accept(cfg.getIntegerValue()));
    }

    public WidgetColorIndicator(int x, int y, int width, int height, IConfigInteger config) {
        super(x, y, width, height);
        this.config = config;
        this.hoverText = ImmutableList.of((Object)StringUtils.translate("malilib.hover.color_indicator.open_color_editor", new Object[0]));
    }

    @Override
    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        GuiColorEditorHSV gui = new GuiColorEditorHSV(this.config, null, GuiUtils.getCurrentScreen());
        GuiBase.openGui(gui);
        return true;
    }

    @Override
    public void postRenderHovered(int mouseX, int mouseY, boolean selected, PoseStack matrixStack) {
        RenderUtils.drawHoverText(mouseX, mouseY, this.hoverText, matrixStack);
    }

    @Override
    public void render(int mouseX, int mouseY, boolean selected, PoseStack matrixStack) {
        int x = this.getX();
        int y = this.getY();
        int z = this.zLevel;
        int width = this.getWidth();
        int height = this.getHeight();
        RenderUtils.drawRect(x, y, width, height, -1, z);
        RenderUtils.drawRect(x + 1, y + 1, width - 2, height - 2, -16777216, z);
        RenderUtils.drawRect(x + 2, y + 2, width - 4, height - 4, 0xFF000000 | this.config.getIntegerValue(), z);
    }
}

