/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.button;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public abstract class ButtonBase
extends WidgetBase {
    protected static final ResourceLocation BUTTON_TEXTURES = new ResourceLocation("minecraft", "textures/gui/widgets.png");
    protected final List<String> hoverStrings = new ArrayList<String>();
    protected final ImmutableList<String> hoverHelp;
    protected String displayString;
    protected boolean enabled = true;
    protected boolean visible = true;
    protected boolean hovered;
    protected boolean hoverInfoRequiresShift;
    @Nullable
    protected IButtonActionListener actionListener;

    public ButtonBase(int x, int y, int width, int height) {
        this(x, y, width, height, "");
    }

    public ButtonBase(int x, int y, int width, int height, String text) {
        this(x, y, width, height, text, null);
    }

    public ButtonBase(int x, int y, int width, int height, String text, @Nullable IButtonActionListener actionListener) {
        super(x, y, width, height);
        if (width < 0) {
            this.width = this.getStringWidth(text) + 10;
        }
        this.displayString = text;
        this.hoverHelp = ImmutableList.of((Object)StringUtils.translate("malilib.gui.button.hover.hold_shift_for_info", new Object[0]));
    }

    public ButtonBase setActionListener(@Nullable IButtonActionListener actionListener) {
        this.actionListener = actionListener;
        return this;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setDisplayString(String text) {
        this.displayString = text;
    }

    public boolean isMouseOver() {
        return this.hovered;
    }

    @Override
    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
        if (this.actionListener != null) {
            this.actionListener.actionPerformedWithButton(this, mouseButton);
        }
        return true;
    }

    @Override
    public boolean onMouseScrolledImpl(int mouseX, int mouseY, double mouseWheelDelta) {
        int mouseButton = mouseWheelDelta < 0.0 ? 1 : 0;
        return this.onMouseClickedImpl(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.enabled && this.visible && super.isMouseOver(mouseX, mouseY);
    }

    public void updateDisplayString() {
    }

    public boolean hasHoverText() {
        return !this.hoverStrings.isEmpty();
    }

    public void setHoverInfoRequiresShift(boolean requireShift) {
        this.hoverInfoRequiresShift = requireShift;
    }

    public void setHoverStrings(String ... hoverStrings) {
        this.setHoverStrings(Arrays.asList(hoverStrings));
    }

    public void setHoverStrings(List<String> hoverStrings) {
        this.hoverStrings.clear();
        for (String str : hoverStrings) {
            String[] parts;
            str = StringUtils.translate(str, new Object[0]);
            for (String part : parts = str.split("\\\\n")) {
                this.hoverStrings.add(StringUtils.translate(part, new Object[0]));
            }
        }
    }

    public List<String> getHoverStrings() {
        if (this.hoverInfoRequiresShift && !GuiBase.isShiftDown()) {
            return this.hoverHelp;
        }
        return this.hoverStrings;
    }

    public void clearHoverStrings() {
        this.hoverStrings.clear();
    }

    protected int getTextureOffset(boolean isMouseOver) {
        return !this.enabled ? 0 : (isMouseOver ? 2 : 1);
    }

    @Override
    public void postRenderHovered(int mouseX, int mouseY, boolean selected, PoseStack matrixStack) {
        if (this.hasHoverText() && this.isMouseOver()) {
            RenderUtils.drawHoverText(mouseX, mouseY, this.getHoverStrings(), matrixStack);
            RenderUtils.disableDiffuseLighting();
        }
    }
}

