/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.event;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import fi.dy.masa.malilib.interfaces.IRenderDispatcher;
import fi.dy.masa.malilib.interfaces.IRenderer;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;

public class RenderEventHandler
implements IRenderDispatcher {
    private static final RenderEventHandler INSTANCE = new RenderEventHandler();
    private final List<IRenderer> overlayRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> tooltipLastRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> worldLastRenderers = new ArrayList<IRenderer>();

    public static IRenderDispatcher getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerGameOverlayRenderer(IRenderer renderer) {
        if (!this.overlayRenderers.contains(renderer)) {
            this.overlayRenderers.add(renderer);
        }
    }

    @Override
    public void registerTooltipLastRenderer(IRenderer renderer) {
        if (!this.tooltipLastRenderers.contains(renderer)) {
            this.tooltipLastRenderers.add(renderer);
        }
    }

    @Override
    public void registerWorldLastRenderer(IRenderer renderer) {
        if (!this.worldLastRenderers.contains(renderer)) {
            this.worldLastRenderers.add(renderer);
        }
    }

    public void onRenderGameOverlayPost(PoseStack matrixStack, Minecraft mc, float partialTicks) {
        mc.m_91307_().m_6180_("malilib_rendergameoverlaypost");
        if (!this.overlayRenderers.isEmpty()) {
            for (IRenderer renderer : this.overlayRenderers) {
                mc.m_91307_().m_6521_(renderer.getProfilerSectionSupplier());
                renderer.onRenderGameOverlayPost(matrixStack);
                mc.m_91307_().m_7238_();
            }
        }
        mc.m_91307_().m_6180_("malilib_ingamemessages");
        InfoUtils.renderInGameMessages(matrixStack);
        mc.m_91307_().m_7238_();
        mc.m_91307_().m_7238_();
    }

    public void onRenderTooltipLast(PoseStack matrixStack, ItemStack stack, int x, int y) {
        if (!this.tooltipLastRenderers.isEmpty()) {
            for (IRenderer renderer : this.tooltipLastRenderers) {
                renderer.onRenderTooltipLast(stack, x, y);
            }
        }
    }

    public void onRenderWorldLast(PoseStack matrixStack, Matrix4f projMatrix, Minecraft mc) {
        if (!this.worldLastRenderers.isEmpty()) {
            RenderTarget fb;
            mc.m_91307_().m_6182_("malilib_renderworldlast");
            RenderTarget renderTarget = fb = Minecraft.m_91085_() ? mc.f_91060_.m_109828_() : null;
            if (fb != null) {
                fb.m_83947_(false);
            }
            for (IRenderer renderer : this.worldLastRenderers) {
                mc.m_91307_().m_6521_(renderer.getProfilerSectionSupplier());
                renderer.onRenderWorldLast(matrixStack, projMatrix);
                mc.m_91307_().m_7238_();
            }
            if (fb != null) {
                mc.m_91385_().m_83947_(false);
            }
        }
    }
}

