/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.options;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigStringList;
import fi.dy.masa.malilib.config.options.ConfigBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConfigStringList
extends ConfigBase<ConfigStringList>
implements IConfigStringList {
    private final ImmutableList<String> defaultValue;
    private final List<String> strings = new ArrayList<String>();

    public ConfigStringList(String name, ImmutableList<String> defaultValue, String comment) {
        super(ConfigType.STRING_LIST, name, comment);
        this.defaultValue = defaultValue;
        this.strings.addAll((Collection<String>)defaultValue);
    }

    @Override
    public List<String> getStrings() {
        return this.strings;
    }

    @Override
    public ImmutableList<String> getDefaultStrings() {
        return this.defaultValue;
    }

    @Override
    public void setStrings(List<String> strings) {
        if (!this.strings.equals(strings)) {
            this.strings.clear();
            this.strings.addAll(strings);
            this.onValueChanged();
        }
    }

    @Override
    public void resetToDefault() {
        this.setStrings((List<String>)this.defaultValue);
    }

    @Override
    public boolean isModified() {
        return !this.strings.equals(this.defaultValue);
    }

    @Override
    public void setValueFromJsonElement(JsonElement element) {
        this.strings.clear();
        try {
            if (element.isJsonArray()) {
                JsonArray arr = element.getAsJsonArray();
                int count = arr.size();
                for (int i = 0; i < count; ++i) {
                    this.strings.add(arr.get(i).getAsString());
                }
            } else {
                MaLiLib.logger.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element);
            }
        }
        catch (Exception e) {
            MaLiLib.logger.warn("Failed to set config value for '{}' from the JSON element '{}'", new Object[]{this.getName(), element, e});
        }
    }

    @Override
    public JsonElement getAsJsonElement() {
        JsonArray arr = new JsonArray();
        for (String str : this.strings) {
            arr.add((JsonElement)new JsonPrimitive(str));
        }
        return arr;
    }
}

