/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.EnhancedTerrainAdaptation;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.EnhancedTerrainAdaptationType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class YungJigsawConfig
implements FeatureConfiguration {
    public static final Codec<YungJigsawConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.f_135803_.fieldOf("start_pool").forGetter(YungJigsawConfig::getStartPool), (App)Codec.INT.fieldOf("size").forGetter(YungJigsawConfig::getMaxDepth), (App)Codec.intRange((int)0, (int)100).optionalFieldOf("structure_set_avoid_radius_check", (Object)0).forGetter(config -> config.structureAvoidRadius), (App)ResourceKey.m_195966_((ResourceKey)Registry.f_211073_).listOf().optionalFieldOf("structure_set_avoid", new ArrayList()).forGetter(config -> config.structureSetAvoid), (App)Codec.INT.optionalFieldOf("max_y").forGetter(structure -> structure.maxY), (App)Codec.INT.optionalFieldOf("min_y").forGetter(structure -> structure.minY), (App)EnhancedTerrainAdaptationType.ADAPTATION_CODEC.optionalFieldOf("enhanced_terrain_adaptation", (Object)EnhancedTerrainAdaptation.NONE).forGetter(structure -> structure.enhancedTerrainAdaptation)).apply((Applicative)builder, YungJigsawConfig::new));
    private final ResourceLocation startPool;
    private final int structureAvoidRadius;
    private final List<ResourceKey<StructureSet>> structureSetAvoid;
    private final Optional<Integer> maxY;
    private final Optional<Integer> minY;
    private final EnhancedTerrainAdaptation enhancedTerrainAdaptation;
    private final int maxDepth;

    public YungJigsawConfig(ResourceLocation startPool, int maxDepth, int structureAvoidRadius, List<ResourceKey<StructureSet>> structureSetAvoid, Optional<Integer> maxY, Optional<Integer> minY, EnhancedTerrainAdaptation enhancedTerrainAdaptation) {
        this.startPool = startPool;
        this.maxDepth = maxDepth;
        this.structureAvoidRadius = structureAvoidRadius;
        this.structureSetAvoid = structureSetAvoid;
        this.maxY = maxY;
        this.minY = minY;
        this.enhancedTerrainAdaptation = enhancedTerrainAdaptation;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public ResourceLocation getStartPool() {
        return this.startPool;
    }

    public int getStructureAvoidRadius() {
        return this.structureAvoidRadius;
    }

    public List<ResourceKey<StructureSet>> getStructureSetAvoid() {
        return this.structureSetAvoid;
    }

    public Optional<Integer> getMaxY() {
        return this.maxY;
    }

    public Optional<Integer> getMinY() {
        return this.minY;
    }

    public EnhancedTerrainAdaptation getEnhancedTerrainAdaptation() {
        return this.enhancedTerrainAdaptation;
    }
}

