/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.boatload.core.data.client;

import com.teamabnormals.boatload.core.other.BoatloadUtil;
import com.teamabnormals.boatload.core.registry.BoatloadEntityTypes;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.LanguageProvider;
import org.apache.commons.lang3.text.WordUtils;

public class BoatloadLanguageProvider
extends LanguageProvider {
    public BoatloadLanguageProvider(DataGenerator gen) {
        super(gen, "boatload", "en_us");
    }

    protected void addTranslations() {
        this.add((EntityType)BoatloadEntityTypes.CHEST_BOAT.get(), "Boat with Chest");
        this.add((EntityType)BoatloadEntityTypes.FURNACE_BOAT.get(), "Boat with Furnace");
        this.add((EntityType)BoatloadEntityTypes.LARGE_BOAT.get(), "Large Boat");
        BoatloadUtil.getChestBoats().forEach(this::addChestBoat);
        BoatloadUtil.getFurnaceBoats().forEach(this::addFurnaceBoat);
        BoatloadUtil.getLargeBoats().forEach(this::add);
    }

    private void add(Item item) {
        if (item.getRegistryName() != null) {
            this.add(item, this.format(item.getRegistryName()));
        }
    }

    private void addChestBoat(Item item) {
        if (item.getRegistryName() != null) {
            this.add(item, this.format(item.getRegistryName()).replace("Chest Boat", "Boat with Chest"));
        }
    }

    private void addFurnaceBoat(Item item) {
        if (item.getRegistryName() != null) {
            this.add(item, this.format(item.getRegistryName()).replace("Furnace Boat", "Boat with Furnace"));
        }
    }

    private String format(ResourceLocation registryName) {
        return WordUtils.capitalizeFully((String)registryName.m_135815_().replace("_", " "));
    }
}

