/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.boatload.core.api;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.boatload.core.registry.BoatloadItems;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public record BoatloadBoatType(ResourceLocation registryName, Supplier<Item> planks, Supplier<Item> boat, Supplier<Item> chestBoat, Supplier<Item> furnaceBoat, Supplier<Item> largeBoat) {
    private static final Set<BoatloadBoatType> BOAT_TYPES = new ObjectArraySet();
    public static final BoatloadBoatType OAK = BoatloadBoatType.register(BoatloadBoatType.create(new ResourceLocation("oak"), () -> Items.f_42647_, () -> Items.f_42453_, () -> (Item)BoatloadItems.OAK_CHEST_BOAT.get(), () -> (Item)BoatloadItems.OAK_FURNACE_BOAT.get(), () -> (Item)BoatloadItems.LARGE_OAK_BOAT.get()));
    public static final BoatloadBoatType BIRCH = BoatloadBoatType.register(BoatloadBoatType.create(new ResourceLocation("birch"), () -> Items.f_42753_, () -> Items.f_42743_, () -> (Item)BoatloadItems.BIRCH_CHEST_BOAT.get(), () -> (Item)BoatloadItems.BIRCH_FURNACE_BOAT.get(), () -> (Item)BoatloadItems.LARGE_BIRCH_BOAT.get()));
    public static final BoatloadBoatType SPRUCE = BoatloadBoatType.register(BoatloadBoatType.create(new ResourceLocation("spruce"), () -> Items.f_42700_, () -> Items.f_42742_, () -> (Item)BoatloadItems.SPRUCE_CHEST_BOAT.get(), () -> (Item)BoatloadItems.SPRUCE_FURNACE_BOAT.get(), () -> (Item)BoatloadItems.LARGE_SPRUCE_BOAT.get()));
    public static final BoatloadBoatType JUNGLE = BoatloadBoatType.register(BoatloadBoatType.create(new ResourceLocation("jungle"), () -> Items.f_42794_, () -> Items.f_42744_, () -> (Item)BoatloadItems.JUNGLE_CHEST_BOAT.get(), () -> (Item)BoatloadItems.JUNGLE_FURNACE_BOAT.get(), () -> (Item)BoatloadItems.LARGE_JUNGLE_BOAT.get()));
    public static final BoatloadBoatType ACACIA = BoatloadBoatType.register(BoatloadBoatType.create(new ResourceLocation("acacia"), () -> Items.f_42795_, () -> Items.f_42745_, () -> (Item)BoatloadItems.ACACIA_CHEST_BOAT.get(), () -> (Item)BoatloadItems.ACACIA_FURNACE_BOAT.get(), () -> (Item)BoatloadItems.LARGE_ACACIA_BOAT.get()));
    public static final BoatloadBoatType DARK_OAK = BoatloadBoatType.register(BoatloadBoatType.create(new ResourceLocation("dark_oak"), () -> Items.f_42796_, () -> Items.f_42746_, () -> (Item)BoatloadItems.DARK_OAK_CHEST_BOAT.get(), () -> (Item)BoatloadItems.DARK_OAK_FURNACE_BOAT.get(), () -> (Item)BoatloadItems.LARGE_DARK_OAK_BOAT.get()));

    public static BoatloadBoatType create(ResourceLocation registryName, Supplier<Item> planks, Supplier<Item> boat, Supplier<Item> chestBoat, Supplier<Item> furnaceBoat, Supplier<Item> largeBoat) {
        return new BoatloadBoatType(registryName, planks, boat, chestBoat, furnaceBoat, largeBoat);
    }

    public static synchronized BoatloadBoatType register(BoatloadBoatType type) {
        BOAT_TYPES.add(type);
        return type;
    }

    public static ImmutableList<BoatloadBoatType> values() {
        return ImmutableList.copyOf(BOAT_TYPES);
    }

    public static BoatloadBoatType getTypeFromString(String name) {
        for (BoatloadBoatType type : BoatloadBoatType.values()) {
            if (!type.registryName().toString().equals(name)) continue;
            return type;
        }
        return OAK;
    }

    public static BoatloadBoatType getTypeFromBoat(Item boat) {
        for (BoatloadBoatType type : BoatloadBoatType.values()) {
            if (type.boat().get() != boat) continue;
            return type;
        }
        return OAK;
    }
}

