/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.boatload.common.entity.vehicle;

import com.teamabnormals.boatload.common.entity.vehicle.BoatloadBoat;
import com.teamabnormals.boatload.core.registry.BoatloadEntityTypes;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;

public class FurnaceBoat
extends BoatloadBoat {
    private static final EntityDataAccessor<Integer> FUEL = SynchedEntityData.m_135353_(FurnaceBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Ingredient FUEL_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42413_, Items.f_42414_});

    public FurnaceBoat(EntityType<? extends Boat> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public FurnaceBoat(Level worldIn, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)BoatloadEntityTypes.FURNACE_BOAT.get()), worldIn);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public FurnaceBoat(PlayMessages.SpawnEntity packet, Level worldIn) {
        super((EntityType<? extends Boat>)((EntityType)BoatloadEntityTypes.FURNACE_BOAT.get()), worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FUEL, (Object)0);
    }

    @Override
    protected void dropBreakItems() {
        super.dropBreakItems();
        this.m_19998_((ItemLike)Blocks.f_50094_);
    }

    @Override
    public void killBoat() {
        super.killBoat();
        this.m_19998_((ItemLike)Blocks.f_50094_);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_6144_()) {
            ItemStack itemstack = player.m_21120_(hand);
            if (FUEL_ITEMS.test(itemstack) && this.getFuel() + 3600 <= 32000) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.setFuel(this.getFuel() + 3600);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6096_(player, hand);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getFuel() > 0) {
            this.setFuel(this.getFuel() - 1);
            float f = (this.m_146908_() - 90.0f) * ((float)Math.PI / 180);
            float f1 = Mth.m_14089_((float)f);
            float f2 = Mth.m_14031_((float)f);
            if (this.f_19853_.f_46443_ && this.f_19796_.nextInt(4) == 0) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + (double)f1 * 0.5, this.m_20186_() + 1.0, this.m_20189_() + (double)f2 * 0.5, 0.0, 0.0, 0.0);
            }
            if (this.f_19796_.nextInt(40) == 0) {
                this.f_19853_.m_7785_(this.m_20185_() + (double)f1 * 0.5, this.m_20186_(), this.m_20189_() + (double)f2 * 0.5, SoundEvents.f_11907_, this.m_5720_(), 1.0f, 1.0f, false);
            }
        }
    }

    protected void m_38396_() {
        if (this.m_20160_()) {
            float f = 0.0f;
            if (this.f_38273_) {
                this.f_38266_ -= 1.0f;
            }
            if (this.f_38274_) {
                this.f_38266_ += 1.0f;
            }
            if (this.f_38274_ != this.f_38273_ && !this.f_38275_ && !this.f_38276_) {
                f += 0.005f;
            }
            this.m_146922_(this.m_146908_() + this.f_38266_);
            if (this.f_38275_) {
                f += 0.04f;
                if (this.getFuel() > 0) {
                    f += 0.026f;
                }
            }
            if (this.f_38276_) {
                f -= 0.005f;
                if (this.getFuel() > 0) {
                    f -= 0.01f;
                }
            }
            this.m_20256_(this.m_20184_().m_82520_((double)(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * f), 0.0, (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * f)));
            this.m_38339_(this.f_38274_ && !this.f_38273_ || this.f_38275_, this.f_38273_ && !this.f_38274_ || this.f_38275_);
            if (this.getFuel() > 0 && this.f_38279_ == Boat.Status.IN_WATER) {
                float f1 = (this.m_146908_() - 90.0f) * ((float)Math.PI / 180);
                float f2 = Mth.m_14089_((float)f1);
                float f3 = Mth.m_14031_((float)f1);
                for (int i = 0; i < 10; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)f2 * 0.8 + (this.f_19796_.nextDouble() - 0.5), this.m_20186_() + (double)0.2f, this.m_20189_() + (double)f3 * 0.8 + (this.f_19796_.nextDouble() - 0.5), 0.0, 0.05, 0.0);
                }
            }
        }
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Fuel", this.getFuel());
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setFuel(compound.m_128451_("Fuel"));
    }

    private void setFuel(@Nullable int fuel) {
        this.f_19804_.m_135381_(FUEL, (Object)fuel);
    }

    @Nullable
    public int getFuel() {
        return (Integer)this.f_19804_.m_135370_(FUEL);
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getBoatloadBoatType().furnaceBoat().get());
    }

    @Override
    public BlockState getDisplayTile() {
        return (BlockState)((BlockState)Blocks.f_50094_.m_49966_().m_61124_((Property)FurnaceBlock.f_48683_, (Comparable)Direction.SOUTH)).m_61124_((Property)FurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(this.getFuel() > 0));
    }

    public void m_7332_(Entity passenger) {
        if (this.m_20363_(passenger)) {
            float f = passenger instanceof Animal ? 0.4f : 0.2f;
            float f1 = (float)((this.m_146910_() ? (double)0.01f : this.m_6048_()) + passenger.m_6049_());
            Vec3 vector3d = new Vec3((double)f, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            passenger.m_6034_(this.m_20185_() + vector3d.f_82479_, this.m_20186_() + (double)f1, this.m_20189_() + vector3d.f_82481_);
            passenger.m_146922_(passenger.m_146908_() + this.f_38266_);
            passenger.m_5616_(passenger.m_6080_() + this.f_38266_);
            this.m_38321_(passenger);
            if (passenger instanceof Animal) {
                int j = passenger.m_142049_() % 2 == 0 ? 90 : 270;
                passenger.m_5618_(((Animal)passenger).f_20883_ + (float)j);
                passenger.m_5616_(passenger.m_6080_() + (float)j);
            }
        }
    }

    protected boolean m_7310_(Entity passenger) {
        return !this.m_20160_() && !this.m_204029_(FluidTags.f_13131_);
    }
}

