/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.boatload.common.entity.vehicle;

import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.boatload.core.api.BoatloadBoatType;
import com.teamabnormals.boatload.core.other.BoatloadTrackedData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;

public abstract class BoatloadBoat
extends Boat {
    private static final EntityDataAccessor<String> BOAT_TYPE = SynchedEntityData.m_135353_(BoatloadBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public BoatloadBoat(EntityType<? extends Boat> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BOAT_TYPE, (Object)BoatloadBoatType.OAK.registryName().toString());
    }

    public void setBoatloadBoatType(BoatloadBoatType boatType) {
        this.f_19804_.m_135381_(BOAT_TYPE, (Object)boatType.registryName().toString());
    }

    public BoatloadBoatType getBoatloadBoatType() {
        return BoatloadBoatType.getTypeFromString((String)this.f_19804_.m_135370_(BOAT_TYPE));
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Type", this.getBoatloadBoatType().registryName().toString());
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Type", 8)) {
            this.setBoatloadBoatType(BoatloadBoatType.getTypeFromString(compound.m_128461_("Type")));
        }
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.f_38281_ = this.m_20184_().f_82480_;
        if (!this.m_20159_()) {
            if (onGroundIn) {
                if (this.f_19789_ > 3.0f) {
                    if (this.f_38279_ != Boat.Status.ON_LAND) {
                        this.f_19789_ = 0.0f;
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, DamageSource.f_19315_);
                    if (!this.f_19853_.f_46443_ && !this.m_146910_()) {
                        this.m_146870_();
                        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                            this.dropBreakItems();
                        }
                    }
                }
                this.f_19789_ = 0.0f;
            } else if (!this.f_19853_.m_6425_(this.m_142538_().m_7495_()).m_205070_(FluidTags.f_13131_) && y < 0.0) {
                this.f_19789_ = (float)((double)this.f_19789_ - y);
            }
        }
    }

    protected void dropBreakItems() {
        for (int i = 0; i < 3; ++i) {
            this.m_19998_((ItemLike)this.getPlanks());
        }
        for (int j = 0; j < 2; ++j) {
            this.m_19998_((ItemLike)Items.f_42398_);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && !this.m_146910_()) {
            boolean flag;
            if (source instanceof IndirectEntityDamageSource && source.m_7639_() != null && this.m_20363_(source.m_7639_())) {
                return false;
            }
            this.m_38362_(-this.m_38386_());
            this.m_38354_(10);
            this.m_38311_(this.m_38384_() + amount * 10.0f);
            this.m_5834_();
            boolean bl = flag = source.m_7639_() instanceof Player && ((Player)source.m_7639_()).m_150110_().f_35937_;
            if (flag || this.m_38384_() > 40.0f) {
                if (!flag && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                    this.killBoat();
                }
                this.m_146870_();
            }
            return true;
        }
        return true;
    }

    public void killBoat() {
        this.m_19998_((ItemLike)this.m_38369_());
        this.m_19983_((ItemStack)((IDataManager)this).getValue(BoatloadTrackedData.BANNER));
    }

    public BlockState getDisplayTile() {
        return Blocks.f_50016_.m_49966_();
    }

    public Item m_38369_() {
        return this.getBoatloadBoatType().boat().get();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected Item getPlanks() {
        return this.getBoatloadBoatType().planks().get();
    }
}

