/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.boatload.common.entity.vehicle;

import com.teamabnormals.boatload.common.entity.vehicle.BoatloadBoat;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class AbstractContainerBoat
extends BoatloadBoat
implements Container,
MenuProvider {
    private NonNullList<ItemStack> boatContainerItems = NonNullList.m_122780_((int)36, (Object)ItemStack.f_41583_);
    private boolean dropContentsWhenDead = true;
    @Nullable
    private ResourceLocation lootTable;
    private long lootTableSeed;
    private LazyOptional<?> itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this));

    public AbstractContainerBoat(EntityType<? extends Boat> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    @Override
    protected void dropBreakItems() {
        super.dropBreakItems();
        if (!this.f_19853_.f_46443_ && this.dropContentsWhenDead && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)this);
        }
    }

    @Override
    public void killBoat() {
        super.killBoat();
        if (!this.f_19853_.f_46443_ && this.dropContentsWhenDead && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)this);
        }
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.boatContainerItems) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        this.unpackLootTable(null);
        return (ItemStack)this.boatContainerItems.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        this.unpackLootTable(null);
        return ContainerHelper.m_18969_(this.boatContainerItems, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        this.unpackLootTable(null);
        ItemStack itemstack = (ItemStack)this.boatContainerItems.get(index);
        if (itemstack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.boatContainerItems.set(index, (Object)ItemStack.f_41583_);
        return itemstack;
    }

    public void m_6836_(int index, ItemStack stack) {
        this.unpackLootTable(null);
        this.boatContainerItems.set(index, (Object)stack);
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public SlotAccess m_141942_(final int slot) {
        return slot >= 0 && slot < this.m_6643_() ? new SlotAccess(){

            public ItemStack m_142196_() {
                return AbstractContainerBoat.this.m_8020_(slot);
            }

            public boolean m_142104_(ItemStack stack) {
                AbstractContainerBoat.this.m_6836_(slot, stack);
                return true;
            }
        } : super.m_141942_(slot);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        if (this.m_146910_()) {
            return false;
        }
        return !(player.m_20280_((Entity)this) > 64.0);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.f_19853_.f_46443_ && reason.m_146965_()) {
            Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)this);
        }
        super.m_142687_(reason);
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.lootTable != null) {
            compound.m_128359_("LootTable", this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                compound.m_128356_("LootTableSeed", this.lootTableSeed);
            }
        } else {
            ContainerHelper.m_18973_((CompoundTag)compound, this.boatContainerItems);
        }
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.boatContainerItems = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (compound.m_128425_("LootTable", 8)) {
            this.lootTable = new ResourceLocation(compound.m_128461_("LootTable"));
            this.lootTableSeed = compound.m_128454_("LootTableSeed");
        } else {
            ContainerHelper.m_18980_((CompoundTag)compound, this.boatContainerItems);
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_6144_()) {
            player.m_5893_((MenuProvider)this);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6096_(player, hand);
    }

    public void unpackLootTable(@Nullable Player player) {
        if (this.lootTable != null && this.f_19853_.m_142572_() != null) {
            LootTable loottable = this.f_19853_.m_142572_().m_129898_().m_79217_(this.lootTable);
            this.lootTable = null;
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)this.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_78965_(this.lootTableSeed);
            lootcontext$builder.m_78972_(LootContextParams.f_81458_, (Object)this);
            if (player != null) {
                lootcontext$builder.m_78963_(player.m_36336_()).m_78972_(LootContextParams.f_81455_, (Object)player);
            }
            loottable.m_79123_((Container)this, lootcontext$builder.m_78975_(LootContextParamSets.f_81411_));
        }
    }

    public void m_6211_() {
        this.unpackLootTable(null);
        this.boatContainerItems.clear();
    }

    public void setLootTable(ResourceLocation lootTableIn, long lootTableSeedIn) {
        this.lootTable = lootTableIn;
        this.lootTableSeed = lootTableSeedIn;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
        if (this.lootTable != null && p_createMenu_3_.m_5833_()) {
            return null;
        }
        this.unpackLootTable(p_createMenu_2_.f_35978_);
        return this.createMenu(p_createMenu_1_, p_createMenu_2_);
    }

    protected abstract AbstractContainerMenu createMenu(int var1, Inventory var2);

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this));
    }

    public void dropContentsWhenDead(boolean value) {
        this.dropContentsWhenDead = value;
    }

    public void m_7332_(Entity passenger) {
        if (this.m_20363_(passenger)) {
            float f = passenger instanceof Animal ? 0.4f : 0.2f;
            float f1 = (float)((this.m_146910_() ? (double)0.01f : this.m_6048_()) + passenger.m_6049_());
            Vec3 vector3d = new Vec3((double)f, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            passenger.m_6034_(this.m_20185_() + vector3d.f_82479_, this.m_20186_() + (double)f1, this.m_20189_() + vector3d.f_82481_);
            passenger.m_146922_(passenger.m_146908_() + this.f_38266_);
            passenger.m_5616_(passenger.m_6080_() + this.f_38266_);
            this.m_38321_(passenger);
            if (passenger instanceof Animal) {
                int j = passenger.m_142049_() % 2 == 0 ? 90 : 270;
                passenger.m_5618_(((Animal)passenger).f_20883_ + (float)j);
                passenger.m_5616_(passenger.m_6080_() + (float)j);
            }
        }
    }

    protected boolean m_7310_(Entity passenger) {
        return !this.m_20160_() && !this.m_204029_(FluidTags.f_13131_);
    }
}

