/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.contact.resourse;

import cloud.lemonslice.contact.resourse.PostcardHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class PostcardStyle {
    public static final PostcardStyle DEFAULT = new PostcardStyle("contact:stripes", 200, 133, 10, 12, 180, 108, -8947589, "contact:postmark", 142, -5, 64, 52, -847808389);
    public final String cardTexture;
    public final int cardWidth;
    public final int cardHeight;
    public final int textPosX;
    public final int textPosY;
    public final int textWidth;
    public final int textHeight;
    public final int textColor;
    public final String postmarkTexture;
    public final int postmarkPosX;
    public final int postmarkPosY;
    public final int postmarkWidth;
    public final int postmarkHeight;
    public final int postmarkColor;

    public PostcardStyle(String cardTexture, int cardWidth, int cardHeight, int textPosX, int textPosY, int textWidth, int textHeight, int textColor, String postmarkTexture, int postmarkPosX, int postmarkPosY, int postmarkWidth, int postmarkHeight, int postmarkColor) {
        this.cardTexture = cardTexture;
        this.cardWidth = cardWidth;
        this.cardHeight = cardHeight;
        this.textPosX = textPosX;
        this.textPosY = textPosY;
        this.textWidth = textWidth;
        this.textHeight = textHeight;
        this.textColor = textColor;
        this.postmarkTexture = postmarkTexture;
        this.postmarkPosX = postmarkPosX;
        this.postmarkPosY = postmarkPosY;
        this.postmarkWidth = postmarkWidth;
        this.postmarkHeight = postmarkHeight;
        this.postmarkColor = postmarkColor;
    }

    public ResourceLocation getCardTexture() {
        ResourceLocation origin = new ResourceLocation(this.cardTexture);
        return new ResourceLocation(origin.m_135827_(), "textures/postcard/" + origin.m_135815_() + ".png");
    }

    public ResourceLocation getPostmarkTexture() {
        ResourceLocation origin = new ResourceLocation(this.postmarkTexture);
        return new ResourceLocation(origin.m_135827_(), "textures/postcard/" + origin.m_135815_() + ".png");
    }

    public static PostcardStyle fromNBT(CompoundTag nbt) {
        if (nbt.m_128441_("Info")) {
            CompoundTag info = nbt.m_128469_("Info");
            String id = "contact:" + info.m_128461_("ID");
            int posX = info.m_128451_("PosX");
            int posY = info.m_128451_("PosY");
            int textWidth = info.m_128451_("Width");
            int textHeight = info.m_128451_("Height");
            int color = info.m_128451_("Color");
            return new PostcardStyle(id, 200, 133, posX, posY, textWidth, textHeight, color, "contact:postmark", 142, -5, 64, 52, color & 0xCDFFFFFF);
        }
        if (nbt.m_128441_("CardID")) {
            ResourceLocation cardID = new ResourceLocation(nbt.m_128461_("CardID"));
            return PostcardHandler.POSTCARD_MANAGER.getPostcards().getOrDefault(cardID, DEFAULT);
        }
        return DEFAULT;
    }
}

