/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.contact.resourse;

import cloud.lemonslice.contact.Contact;
import cloud.lemonslice.contact.network.PostcardReloadMessage;
import cloud.lemonslice.contact.network.SimpleNetworkHandler;
import cloud.lemonslice.contact.resourse.PostcardHandler;
import cloud.lemonslice.contact.resourse.PostcardStyle;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class PostcardManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private Map<ResourceLocation, PostcardStyle> postcards = ImmutableMap.of();

    public PostcardManager() {
        super(GSON, "postcards");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, JsonElement> entry : objectIn.entrySet()) {
            ResourceLocation location = entry.getKey();
            if (location.m_135815_().startsWith("_")) continue;
            try {
                PostcardStyle style = PostcardHandler.read(GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"top element"));
                map.put((Object)location, (Object)style);
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                Contact.error("Parsing error loading postcard style %s, throws %s", location, exception);
            }
        }
        this.postcards = map.build();
        Contact.info("Loaded %s postcard styles", this.postcards.size());
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                SimpleNetworkHandler.CHANNEL.sendTo((Object)new PostcardReloadMessage(), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    public void getPostcardsFromServer(Map<ResourceLocation, PostcardStyle> postcards) {
        this.postcards = postcards;
        Contact.info("Reloaded %d postcard styles from server", postcards.size());
    }

    public Map<ResourceLocation, PostcardStyle> getPostcards() {
        return this.postcards;
    }

    public PostcardStyle getPostcard(ResourceLocation id) {
        return this.postcards.getOrDefault(id, PostcardStyle.DEFAULT);
    }
}

