/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.contact.resourse;

import cloud.lemonslice.contact.network.PostcardReloadMessage;
import cloud.lemonslice.contact.network.SimpleNetworkHandler;
import cloud.lemonslice.contact.resourse.PostcardManager;
import cloud.lemonslice.contact.resourse.PostcardStyle;
import cloud.lemonslice.silveroak.helper.ColorHelper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;

@Mod.EventBusSubscriber
public final class PostcardHandler {
    public static final PostcardManager POSTCARD_MANAGER = new PostcardManager();

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)POSTCARD_MANAGER);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayer && !(event.getPlayer() instanceof FakePlayer)) {
            SimpleNetworkHandler.CHANNEL.sendTo((Object)new PostcardReloadMessage(), ((ServerPlayer)event.getPlayer()).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static PostcardStyle read(JsonObject json) {
        if (!json.has("postcard")) {
            throw new JsonSyntaxException("Missing postcard data, expected to find object");
        }
        JsonObject postcardData = GsonHelper.m_13930_((JsonObject)json, (String)"postcard");
        String cardTexture = GsonHelper.m_13906_((JsonObject)postcardData, (String)"texture");
        int cardWidth = GsonHelper.m_13927_((JsonObject)postcardData, (String)"width");
        int cardHeight = GsonHelper.m_13927_((JsonObject)postcardData, (String)"height");
        int textPosX = 10;
        int textPosY = 12;
        int textWidth = 180;
        int textHeight = 108;
        int textColor = -16777216;
        if (json.has("text")) {
            JsonObject textData = GsonHelper.m_13930_((JsonObject)json, (String)"text");
            textPosX = GsonHelper.m_13927_((JsonObject)textData, (String)"x");
            textPosY = GsonHelper.m_13927_((JsonObject)textData, (String)"y");
            textWidth = GsonHelper.m_13927_((JsonObject)textData, (String)"width");
            textHeight = GsonHelper.m_13927_((JsonObject)textData, (String)"height");
            if (textData.has("color")) {
                JsonObject color = GsonHelper.m_13930_((JsonObject)textData, (String)"color");
                int alpha = (GsonHelper.m_13927_((JsonObject)color, (String)"alpha") & 0xFF) << 24;
                int red = (GsonHelper.m_13927_((JsonObject)color, (String)"red") & 0xFF) << 16;
                int green = (GsonHelper.m_13927_((JsonObject)color, (String)"green") & 0xFF) << 8;
                int blue = GsonHelper.m_13927_((JsonObject)color, (String)"blue") & 0xFF;
                textColor = alpha + red + blue + green;
            }
        }
        String postmarkTexture = "contact:postmark";
        int postmarkPosX = 142;
        int postmarkPosY = -5;
        int postmarkWidth = 64;
        int postmarkHeight = 52;
        int postmarkColor = textColor;
        if (json.has("postmark")) {
            JsonObject postmarkData = GsonHelper.m_13930_((JsonObject)json, (String)"postmark");
            postmarkTexture = GsonHelper.m_13906_((JsonObject)postmarkData, (String)"texture");
            postmarkPosX = GsonHelper.m_13927_((JsonObject)postmarkData, (String)"x");
            postmarkPosY = GsonHelper.m_13927_((JsonObject)postmarkData, (String)"y");
            postmarkWidth = GsonHelper.m_13927_((JsonObject)postmarkData, (String)"width");
            postmarkHeight = GsonHelper.m_13927_((JsonObject)postmarkData, (String)"height");
            if (postmarkData.has("color")) {
                JsonObject color = GsonHelper.m_13930_((JsonObject)postmarkData, (String)"color");
                int alpha = (GsonHelper.m_13927_((JsonObject)color, (String)"alpha") & 0xFF) << 24;
                int red = (GsonHelper.m_13927_((JsonObject)color, (String)"red") & 0xFF) << 16;
                int green = (GsonHelper.m_13927_((JsonObject)color, (String)"green") & 0xFF) << 8;
                int blue = GsonHelper.m_13927_((JsonObject)color, (String)"blue") & 0xFF;
                postmarkColor = alpha + red + blue + green;
            }
        }
        return new PostcardStyle(cardTexture, cardWidth, cardHeight, textPosX, textPosY, textWidth, textHeight, textColor, postmarkTexture, postmarkPosX, postmarkPosY, postmarkWidth, postmarkHeight, postmarkColor);
    }

    public static PostcardStyle read(FriendlyByteBuf buffer) {
        String cardID = buffer.m_130136_(Short.MAX_VALUE);
        int cardWidth = buffer.readInt();
        int cardHeight = buffer.readInt();
        int textPosX = buffer.readInt();
        int textPosY = buffer.readInt();
        int textWidth = buffer.readInt();
        int textHeight = buffer.readInt();
        int textColor = buffer.readInt();
        String postmarkID = buffer.m_130136_(Short.MAX_VALUE);
        int postmarkPosX = buffer.readInt();
        int postmarkPosY = buffer.readInt();
        int postmarkWidth = buffer.readInt();
        int postmarkHeight = buffer.readInt();
        int postmarkColor = buffer.readInt();
        return new PostcardStyle(cardID, cardWidth, cardHeight, textPosX, textPosY, textWidth, textHeight, textColor, postmarkID, postmarkPosX, postmarkPosY, postmarkWidth, postmarkHeight, postmarkColor);
    }

    public static void write(FriendlyByteBuf buffer, PostcardStyle style) {
        buffer.m_130072_(style.cardTexture, Short.MAX_VALUE);
        buffer.writeInt(style.cardWidth);
        buffer.writeInt(style.cardHeight);
        buffer.writeInt(style.textPosX);
        buffer.writeInt(style.textPosY);
        buffer.writeInt(style.textWidth);
        buffer.writeInt(style.textHeight);
        buffer.writeInt(style.textColor);
        buffer.m_130072_(style.postmarkTexture, Short.MAX_VALUE);
        buffer.writeInt(style.postmarkPosX);
        buffer.writeInt(style.postmarkPosY);
        buffer.writeInt(style.postmarkWidth);
        buffer.writeInt(style.postmarkHeight);
        buffer.writeInt(style.postmarkColor);
    }

    public static void serialize(JsonObject json, PostcardStyle style) {
        JsonObject postcardData = new JsonObject();
        postcardData.addProperty("texture", style.cardTexture);
        postcardData.addProperty("width", (Number)style.cardWidth);
        postcardData.addProperty("height", (Number)style.cardHeight);
        json.add("postcard", (JsonElement)postcardData);
        JsonObject textData = new JsonObject();
        textData.addProperty("x", (Number)style.textPosX);
        textData.addProperty("y", (Number)style.textPosY);
        textData.addProperty("width", (Number)style.textWidth);
        textData.addProperty("height", (Number)style.textHeight);
        JsonObject textColor = new JsonObject();
        textColor.addProperty("alpha", (Number)ColorHelper.getAlpha((int)style.textColor));
        textColor.addProperty("red", (Number)ColorHelper.getRed((int)style.textColor));
        textColor.addProperty("green", (Number)ColorHelper.getGreen((int)style.textColor));
        textColor.addProperty("blue", (Number)ColorHelper.getBlue((int)style.textColor));
        textData.add("color", (JsonElement)textColor);
        json.add("text", (JsonElement)textData);
        JsonObject postmarkData = new JsonObject();
        postmarkData.addProperty("texture", style.postmarkTexture);
        postmarkData.addProperty("x", (Number)style.postmarkPosX);
        postmarkData.addProperty("y", (Number)style.postmarkPosY);
        postmarkData.addProperty("width", (Number)style.postmarkWidth);
        postmarkData.addProperty("height", (Number)style.postmarkHeight);
        JsonObject postmarkColor = new JsonObject();
        postmarkColor.addProperty("alpha", (Number)ColorHelper.getAlpha((int)style.postmarkColor));
        postmarkColor.addProperty("red", (Number)ColorHelper.getRed((int)style.postmarkColor));
        postmarkColor.addProperty("green", (Number)ColorHelper.getGreen((int)style.postmarkColor));
        postmarkColor.addProperty("blue", (Number)ColorHelper.getBlue((int)style.postmarkColor));
        postmarkData.add("color", (JsonElement)postmarkColor);
        json.add("postmark", (JsonElement)postmarkData);
    }
}

