/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.contact.network;

import cloud.lemonslice.contact.network.ActionMessage;
import cloud.lemonslice.contact.network.AddresseeDataMessage;
import cloud.lemonslice.contact.network.EnquireAddresseeMessage;
import cloud.lemonslice.contact.network.PostcardEditMessage;
import cloud.lemonslice.contact.network.PostcardReloadMessage;
import cloud.lemonslice.silveroak.network.INormalMessage;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public final class SimpleNetworkHandler {
    public static final String NETWORK_VERSION = "1.0";
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("contact", "main")).networkProtocolVersion(() -> "1.0").serverAcceptedVersions("1.0"::equals).clientAcceptedVersions("1.0"::equals).simpleChannel();

    public static void init() {
        int id = 0;
        SimpleNetworkHandler.registerMessage(id++, ActionMessage.class, ActionMessage::new);
        SimpleNetworkHandler.registerMessage(id++, EnquireAddresseeMessage.class, EnquireAddresseeMessage::new, NetworkDirection.PLAY_TO_SERVER);
        SimpleNetworkHandler.registerMessage(id++, AddresseeDataMessage.class, AddresseeDataMessage::new, NetworkDirection.PLAY_TO_CLIENT);
        SimpleNetworkHandler.registerMessage(id++, PostcardEditMessage.class, PostcardEditMessage::new, NetworkDirection.PLAY_TO_SERVER);
        SimpleNetworkHandler.registerMessage(id++, PostcardReloadMessage.class, PostcardReloadMessage::new, NetworkDirection.PLAY_TO_CLIENT);
    }

    private static <T extends INormalMessage> void registerMessage(int index, Class<T> messageType, Function<FriendlyByteBuf, T> decoder) {
        CHANNEL.registerMessage(index, messageType, INormalMessage::toBytes, decoder, (message, context) -> {
            message.process(context);
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        });
    }

    private static <T extends INormalMessage> void registerMessage(int index, Class<T> messageType, Function<FriendlyByteBuf, T> decoder, NetworkDirection direction) {
        CHANNEL.registerMessage(index, messageType, INormalMessage::toBytes, decoder, (message, context) -> {
            message.process(context);
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        }, Optional.of(direction));
    }
}

