/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.contact.network;

import cloud.lemonslice.contact.resourse.PostcardHandler;
import cloud.lemonslice.contact.resourse.PostcardStyle;
import cloud.lemonslice.silveroak.network.INormalMessage;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class PostcardReloadMessage
implements INormalMessage {
    private Map<ResourceLocation, PostcardStyle> postcards;

    public PostcardReloadMessage() {
        this.postcards = PostcardHandler.POSTCARD_MANAGER.getPostcards();
    }

    public PostcardReloadMessage(FriendlyByteBuf buf) {
        int n = buf.readInt();
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (int i = 0; i < n; ++i) {
            ResourceLocation id = buf.m_130281_();
            PostcardStyle style = PostcardHandler.read(buf);
            map.put((Object)id, (Object)style);
        }
        this.postcards = map.build();
    }

    public void toBytes(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(PostcardHandler.POSTCARD_MANAGER.getPostcards().size());
        PostcardHandler.POSTCARD_MANAGER.getPostcards().forEach((id, style) -> {
            packetBuffer.m_130085_(id);
            PostcardHandler.write(packetBuffer, style);
        });
    }

    public void process(Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> PostcardHandler.POSTCARD_MANAGER.getPostcardsFromServer(this.postcards));
    }
}

