/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.contact.network;

import cloud.lemonslice.contact.common.capability.CapabilityRegistry;
import cloud.lemonslice.contact.common.capability.MailToBeSent;
import cloud.lemonslice.contact.common.container.PostboxContainer;
import cloud.lemonslice.contact.common.handler.AdvancementManager;
import cloud.lemonslice.contact.common.handler.MailboxManager;
import cloud.lemonslice.contact.common.item.PostcardItem;
import cloud.lemonslice.contact.network.AddresseeDataMessage;
import cloud.lemonslice.contact.network.SimpleNetworkHandler;
import cloud.lemonslice.silveroak.network.INormalMessage;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class EnquireAddresseeMessage
implements INormalMessage {
    private final String nameIn;
    private final boolean shouldSend;

    public EnquireAddresseeMessage(String name, boolean shouldSend) {
        this.nameIn = name;
        this.shouldSend = shouldSend;
    }

    public EnquireAddresseeMessage(FriendlyByteBuf buf) {
        this.nameIn = buf.m_130136_(Short.MAX_VALUE);
        this.shouldSend = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130072_(this.nameIn, Short.MAX_VALUE);
        buf.writeBoolean(this.shouldSend);
    }

    public void process(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        ctx.enqueueWork(() -> {
            if (this.nameIn.isEmpty()) {
                SimpleNetworkHandler.CHANNEL.sendTo((Object)new AddresseeDataMessage(this.nameIn, -1), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                return;
            }
            player.f_8924_.m_129880_(Level.f_46428_).getCapability(CapabilityRegistry.WORLD_MAILBOX_DATA).ifPresent(data -> {
                String lowerIn = this.nameIn.toLowerCase(Locale.ROOT);
                if (lowerIn.equals("@e") && player.f_8924_.m_129944_(player.m_36316_()) >= 2) {
                    if (this.shouldSend) {
                        if (player.f_36096_ instanceof PostboxContainer) {
                            PostboxContainer container = (PostboxContainer)player.f_36096_;
                            ItemStack parcel = container.parcel.getStackInSlot(0).m_41777_();
                            parcel.m_41784_().m_128359_("Sender", player.m_7755_().getString());
                            for (UUID uuid : data.getData().nameToUUID.values()) {
                                data.getData().mailList.add(new MailToBeSent(uuid, parcel.m_41777_(), 0L));
                            }
                            SimpleNetworkHandler.CHANNEL.sendTo((Object)new AddresseeDataMessage(lowerIn, -3), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                            container.parcel.setStackInSlot(0, ItemStack.f_41583_);
                        }
                        return;
                    }
                    SimpleNetworkHandler.CHANNEL.sendTo((Object)new AddresseeDataMessage(lowerIn, 0), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                    return;
                }
                for (String name : data.getData().nameToUUID.keySet()) {
                    if (!name.toLowerCase(Locale.ROOT).startsWith(lowerIn)) continue;
                    UUID uuid = data.getData().nameToUUID.get(name);
                    if (data.getData().isMailboxFull(uuid)) {
                        SimpleNetworkHandler.CHANNEL.sendTo((Object)new AddresseeDataMessage(name, -2), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                        return;
                    }
                    GlobalPos mailboxPos = data.getData().getMailboxPos(uuid);
                    if (!(player.f_36096_ instanceof PostboxContainer)) continue;
                    int ticks = 0;
                    if (!((PostboxContainer)player.f_36096_).isEnderMail()) {
                        ticks = mailboxPos != null ? MailboxManager.getDeliveryTicks((ResourceKey<Level>)player.f_19853_.m_46472_(), player.m_142538_(), (ResourceKey<Level>)mailboxPos.m_122640_(), mailboxPos.m_122646_()) : MailboxManager.getDeliveryTicks((ResourceKey<Level>)player.f_19853_.m_46472_(), player.m_142538_(), (ResourceKey<Level>)Level.f_46428_, BlockPos.f_121853_);
                    }
                    if (this.shouldSend) {
                        PostboxContainer container = (PostboxContainer)player.f_36096_;
                        ItemStack parcel = container.parcel.getStackInSlot(0);
                        parcel.m_41784_().m_128359_("Sender", player.m_7755_().getString());
                        if (parcel.m_41720_() instanceof PostcardItem) {
                            AdvancementManager.givePlayerAdvancement(player.f_8924_, player, new ResourceLocation("contact:send_postcard"));
                        }
                        if (mailboxPos != null) {
                            if (mailboxPos.m_122640_() != player.f_19853_.m_46472_()) {
                                parcel.m_41784_().m_128379_("AnotherWorld", true);
                            }
                        } else if (Level.f_46428_ != player.f_19853_.m_46472_()) {
                            parcel.m_41784_().m_128379_("AnotherWorld", true);
                        }
                        data.getData().mailList.add(new MailToBeSent(uuid, parcel, ticks));
                        SimpleNetworkHandler.CHANNEL.sendTo((Object)new AddresseeDataMessage(name, -3), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                        container.parcel.setStackInSlot(0, ItemStack.f_41583_);
                    } else {
                        SimpleNetworkHandler.CHANNEL.sendTo((Object)new AddresseeDataMessage(name, ticks), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                    }
                    return;
                }
                SimpleNetworkHandler.CHANNEL.sendTo((Object)new AddresseeDataMessage(this.nameIn, -1), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
            });
        });
    }
}

