/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.contact.network;

import cloud.lemonslice.contact.client.ClientProxy;
import cloud.lemonslice.contact.common.container.WrappingPaperContainer;
import cloud.lemonslice.silveroak.network.INormalMessage;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class ActionMessage
implements INormalMessage {
    private final int action;

    public ActionMessage(int action) {
        this.action = action;
    }

    public ActionMessage(FriendlyByteBuf buf) {
        this.action = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(this.action);
    }

    public void process(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        if (ctx.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            if (this.action == 0) {
                ClientProxy.notifyNewMail(ctx);
            }
        } else if (ctx.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            if (this.action == 0) {
                ActionMessage.packParcel(ctx, player);
            }
        }
    }

    private static void packParcel(NetworkEvent.Context ctx, ServerPlayer player) {
        ctx.enqueueWork(() -> {
            if (player.f_36096_ instanceof WrappingPaperContainer) {
                ((WrappingPaperContainer)player.f_36096_).isPacked = true;
                player.m_6915_();
            }
        });
    }
}

