/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.contact.common.tileentity;

import cloud.lemonslice.contact.common.block.MailboxBlock;
import cloud.lemonslice.contact.common.capability.CapabilityRegistry;
import cloud.lemonslice.contact.common.tileentity.BlockEntityTypeRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MailboxBlockEntity
extends BlockEntity {
    private boolean isOpened = false;
    private boolean needRefresh = false;
    private int refreshTicks = 20;
    private int angel = 0;

    public MailboxBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityTypeRegistry.MAILBOX_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.isOpened = tag.m_128471_("IsOpened");
    }

    public void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128379_("IsOpened", this.isOpened);
    }

    public void refreshStatus() {
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_142572_().m_129880_(Level.f_46428_).getCapability(CapabilityRegistry.WORLD_MAILBOX_DATA).ifPresent(data -> {
                boolean now;
                boolean bl = now = !data.getData().isMailboxEmpty(data.getData().getMailboxOwner((ResourceKey<Level>)this.f_58857_.m_46472_(), this.f_58858_));
                if (now != this.isOpened) {
                    this.needRefresh = true;
                    this.isOpened = now;
                    this.refresh();
                }
            });
        }
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, MailboxBlockEntity pBlockEntity) {
        if (!pLevel.f_46443_) {
            if (pBlockEntity.refreshTicks >= 0) {
                --pBlockEntity.refreshTicks;
            }
            if (pBlockEntity.needRefresh || pBlockEntity.refreshTicks == 0) {
                pBlockEntity.refreshStatus();
                BlockState down = pLevel.m_8055_(pPos.m_7495_());
                if (!(down.m_60734_() instanceof MailboxBlock) || (Boolean)down.m_61143_((Property)MailboxBlock.OPEN) == pBlockEntity.isOpened) {
                    pBlockEntity.needRefresh = false;
                    return;
                }
                pLevel.m_46597_(pPos.m_7495_(), (BlockState)down.m_61124_((Property)MailboxBlock.OPEN, (Comparable)Boolean.valueOf(pBlockEntity.isOpened)));
                pBlockEntity.needRefresh = false;
                if (pState.m_60734_() instanceof MailboxBlock) {
                    pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)MailboxBlock.OPEN, (Comparable)Boolean.valueOf(pBlockEntity.isOpened)));
                }
            }
        } else if (pBlockEntity.isOpened) {
            ++pBlockEntity.angel;
            pBlockEntity.angel %= 40;
        }
    }

    private void refresh() {
        if (this.m_58898_() && !this.f_58857_.f_46443_) {
            ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
            List players = ((ServerLevel)this.f_58857_).m_7726_().f_8325_.m_183262_(new ChunkPos(this.f_58858_.m_123341_() >> 4, this.f_58858_.m_123343_() >> 4), false);
            for (ServerPlayer player : players) {
                player.f_8906_.m_141995_((Packet)packet);
            }
        }
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public int getAngel() {
        return this.angel;
    }
}

