/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.contact.common.item;

import cloud.lemonslice.contact.Contact;
import cloud.lemonslice.contact.client.ClientProxy;
import cloud.lemonslice.contact.common.item.IMailItem;
import cloud.lemonslice.contact.common.item.ItemRegistry;
import cloud.lemonslice.contact.resourse.PostcardHandler;
import cloud.lemonslice.silveroak.common.item.NormalItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PostcardItem
extends NormalItem
implements IMailItem {
    private final boolean isEnderType;

    public PostcardItem(boolean isEnderType) {
        super(new Item.Properties().m_41491_(Contact.ITEM_GROUP).m_41487_(1));
        this.isEnderType = isEnderType;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (worldIn.f_46443_) {
            if (itemstack.m_41784_().m_128441_("Sender")) {
                ClientProxy.openPostcardToRead(itemstack);
            } else {
                ClientProxy.openPostcardToEdit(itemstack, playerIn, handIn);
            }
        }
        playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)worldIn.m_5776_());
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            for (ResourceLocation id : PostcardHandler.POSTCARD_MANAGER.getPostcards().keySet()) {
                items.add((Object)PostcardItem.getPostcard(id, this.isEnderType()));
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41784_().m_128441_("Info")) {
            MutableComponent background = new TranslatableComponent("tooltip.contact.postcard." + stack.m_41784_().m_128469_("Info").m_128461_("ID")).m_130940_(ChatFormatting.GRAY);
            tooltip.add((Component)new TranslatableComponent("tooltip.contact.postcard.background", new Object[]{background}).m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_41784_().m_128441_("CardID")) {
            ResourceLocation id = new ResourceLocation(stack.m_41784_().m_128461_("CardID"));
            MutableComponent background = new TranslatableComponent("tooltip.postcard." + id.m_135827_() + "." + id.m_135815_()).m_130940_(ChatFormatting.GRAY);
            tooltip.add((Component)new TranslatableComponent("tooltip.contact.postcard.background", new Object[]{background}).m_130940_(ChatFormatting.GRAY));
        }
        this.addSenderInfoTooltip(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public boolean isEnderType() {
        return this.isEnderType;
    }

    public static ItemStack getPostcard(ResourceLocation id, boolean isEnderType) {
        ItemStack postcard = new ItemStack(isEnderType ? (ItemLike)ItemRegistry.ENDER_POSTCARD.get() : (ItemLike)ItemRegistry.POSTCARD.get());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("CardID", id.toString());
        postcard.m_41751_(nbt);
        return postcard;
    }

    public static ItemStack setText(ItemStack postcard, String text) {
        postcard.m_41700_("Text", (Tag)StringTag.m_129297_((String)text));
        return postcard;
    }
}

