/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.contact.common.handler;

import cloud.lemonslice.contact.common.capability.CapabilityRegistry;
import cloud.lemonslice.contact.common.capability.MailToBeSent;
import cloud.lemonslice.contact.common.capability.PlayerMailboxData;
import cloud.lemonslice.contact.common.config.ServerConfig;
import cloud.lemonslice.contact.common.item.PostcardItem;
import cloud.lemonslice.contact.common.tileentity.MailboxBlockEntity;
import cloud.lemonslice.contact.network.ActionMessage;
import cloud.lemonslice.contact.network.SimpleNetworkHandler;
import cloud.lemonslice.contact.resourse.PostcardHandler;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public final class MailboxManager {
    private static final List<MailToBeSent> READY_TO_REMOVE = Lists.newArrayList();
    private static int updateTick = 0;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_).getCapability(CapabilityRegistry.WORLD_MAILBOX_DATA).ifPresent(data -> {
                ++updateTick;
                if ((updateTick %= 20) == 0) {
                    for (MailToBeSent mail : data.getData().mailList) {
                        mail.tick(20);
                        if (!mail.isReady()) continue;
                        UUID uuid = mail.getUUID();
                        if (!data.getData().addMailboxContents(uuid, mail.getContents())) continue;
                        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(uuid);
                        if (player != null) {
                            player.m_5661_((Component)new TranslatableComponent("message.contact.mailbox.new_mail"), false);
                        }
                        MailboxManager.updateState(uuid, data.getData());
                        READY_TO_REMOVE.add(mail);
                    }
                    data.getData().mailList.removeAll(READY_TO_REMOVE);
                    READY_TO_REMOVE.clear();
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        event.getPlayer().m_183503_().getCapability(CapabilityRegistry.WORLD_MAILBOX_DATA).ifPresent(data -> {
            data.getData().nameToUUID.put(event.getPlayer().m_7755_().getString(), event.getPlayer().m_142081_());
            if (data.getData().uuidToContents.get(event.getPlayer().m_142081_()) == null) {
                data.getData().resetMailboxContents(event.getPlayer().m_142081_());
            } else {
                if (!data.getData().isMailboxEmpty(event.getPlayer().m_142081_())) {
                    SimpleNetworkHandler.CHANNEL.sendTo((Object)new ActionMessage(0), ((ServerPlayer)event.getPlayer()).f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                }
                MailboxManager.updateState(event.getPlayer().m_142081_(), data.getData());
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        if (!event.getWorld().f_46443_ && event.getTarget() instanceof WanderingTrader && !event.getTarget().m_19880_().contains("SellPostcard")) {
            WanderingTrader trader = (WanderingTrader)event.getTarget();
            int i = event.getWorld().f_46441_.nextInt(PostcardHandler.POSTCARD_MANAGER.getPostcards().size());
            trader.m_19880_().add("SellPostcard");
            ResourceLocation[] list = PostcardHandler.POSTCARD_MANAGER.getPostcards().keySet().toArray(new ResourceLocation[0]);
            trader.m_6616_().add(0, (Object)new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_), new ItemStack((ItemLike)Items.f_42584_), PostcardItem.getPostcard(list[i], true), 4, 10, 0.05f));
            trader.m_6616_().add(0, (Object)new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_), PostcardItem.getPostcard(list[i], false), 4, 10, 0.05f));
        }
    }

    public static void updateState(UUID uuid, PlayerMailboxData data) {
        GlobalPos posData = data.getMailboxPos(uuid);
        if (posData != null) {
            MailboxManager.updateState((Level)ServerLifecycleHooks.getCurrentServer().m_129880_(posData.m_122640_()), posData.m_122646_());
        }
    }

    public static void updateState(Level world, BlockPos pos) {
        BlockEntity te;
        if (world != null && world.isAreaLoaded(pos, 1) && (te = world.m_7702_(pos)) instanceof MailboxBlockEntity) {
            ((MailboxBlockEntity)te).refreshStatus();
        }
    }

    public static int getDeliveryTicks(ResourceKey<Level> fromWorld, BlockPos fromPos, ResourceKey<Level> toWorld, BlockPos toPos) {
        int distance;
        int time = 0;
        if (fromWorld != toWorld) {
            time += ((Integer)ServerConfig.Mail.ticksToAnotherWorld.get()).intValue();
        }
        if ((distance = Math.abs(fromPos.m_123341_() - toPos.m_123341_()) + Math.abs(fromPos.m_123343_() - toPos.m_123343_())) > 9000) {
            distance = 9000;
        }
        return time += (Integer)ServerConfig.Mail.postalSpeed.get() * distance;
    }

    public static int getDeliveryTicks(GlobalPos fromPos, GlobalPos toPos) {
        return MailboxManager.getDeliveryTicks((ResourceKey<Level>)fromPos.m_122640_(), fromPos.m_122646_(), (ResourceKey<Level>)toPos.m_122640_(), toPos.m_122646_());
    }
}

