/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.contact.common.command;

import cloud.lemonslice.contact.common.capability.CapabilityRegistry;
import cloud.lemonslice.contact.common.capability.MailToBeSent;
import cloud.lemonslice.contact.common.command.arguments.PostcardStyleArgument;
import cloud.lemonslice.contact.common.item.ItemRegistry;
import cloud.lemonslice.contact.common.item.ParcelItem;
import cloud.lemonslice.contact.common.item.PostcardItem;
import cloud.lemonslice.contact.resourse.PostcardHandler;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ContactCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_PLAYERS = (context, builder) -> {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        HashSet set = Sets.newHashSet();
        if (server != null) {
            set.addAll(server.m_129880_(Level.f_46428_).getCapability(CapabilityRegistry.WORLD_MAILBOX_DATA).map(data -> data.getData().nameToUUID.keySet()).orElse(Sets.newHashSet()));
        }
        set.add("\"@e\"");
        return SharedSuggestionProvider.m_82970_((Iterable)set, (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_POSTCARDS = (context, builder) -> {
        Set<ResourceLocation> collection = PostcardHandler.POSTCARD_MANAGER.getPostcards().keySet();
        return SharedSuggestionProvider.m_82926_(collection, (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"contact").requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"postcard").then(Commands.m_82127_((String)"give").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"postcard", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_POSTCARDS).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"isEnderType", (ArgumentType)BoolArgumentType.bool()).executes(context -> ContactCommand.givePostcard((CommandSourceStack)context.getSource(), PostcardStyleArgument.getPostcardStyleID((CommandContext<CommandSourceStack>)context, "postcard"), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), "", BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ""))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"sender", (ArgumentType)StringArgumentType.string()).executes(context -> ContactCommand.givePostcard((CommandSourceStack)context.getSource(), PostcardStyleArgument.getPostcardStyleID((CommandContext<CommandSourceStack>)context, "postcard"), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), StringArgumentType.getString((CommandContext)context, (String)"text")))).then(Commands.m_82129_((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(context -> ContactCommand.givePostcard((CommandSourceStack)context.getSource(), PostcardStyleArgument.getPostcardStyleID((CommandContext<CommandSourceStack>)context, "postcard"), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), StringArgumentType.getString((CommandContext)context, (String)"text")))))))))).then(Commands.m_82127_((String)"deliver").then(Commands.m_82129_((String)"targets", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_PLAYERS).then(Commands.m_82129_((String)"postcard", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_POSTCARDS).then(Commands.m_82129_((String)"isEnderType", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"sender", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1728000)).executes(context -> ContactCommand.deliverPostcard((CommandSourceStack)context.getSource(), PostcardStyleArgument.getPostcardStyleID((CommandContext<CommandSourceStack>)context, "postcard"), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ""))).then(Commands.m_82129_((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(context -> ContactCommand.deliverPostcard((CommandSourceStack)context.getSource(), PostcardStyleArgument.getPostcardStyleID((CommandContext<CommandSourceStack>)context, "postcard"), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), StringArgumentType.getString((CommandContext)context, (String)"text")))))))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"parcel").then(Commands.m_82127_((String)"give").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"isEnderType", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"sender", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"item1", (ArgumentType)ItemArgument.m_120960_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"count1", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.giveParcel((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.m_120963_((CommandContext)context, (String)"item1").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false)))).then(Commands.m_82129_((String)"item2", (ArgumentType)ItemArgument.m_120960_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"count2", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.giveParcel((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.m_120963_((CommandContext)context, (String)"item1").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item2").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false)))).then(Commands.m_82129_((String)"item3", (ArgumentType)ItemArgument.m_120960_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"count3", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.giveParcel((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.m_120963_((CommandContext)context, (String)"item1").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item2").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item3").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count3"), false)))).then(Commands.m_82129_((String)"item4", (ArgumentType)ItemArgument.m_120960_()).then(Commands.m_82129_((String)"count4", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.giveParcel((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.m_120963_((CommandContext)context, (String)"item1").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item2").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item3").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count3"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item4").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count4"), false)))))))))))))))).then(Commands.m_82127_((String)"deliver").then(Commands.m_82129_((String)"targets", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_PLAYERS).then(Commands.m_82129_((String)"isEnderType", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"sender", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1728000)).then(Commands.m_82129_((String)"item1", (ArgumentType)ItemArgument.m_120960_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"count1", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.deliverParcel((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.m_120963_((CommandContext)context, (String)"item1").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false)))).then(Commands.m_82129_((String)"item2", (ArgumentType)ItemArgument.m_120960_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"count2", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.deliverParcel((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.m_120963_((CommandContext)context, (String)"item1").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item2").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false)))).then(Commands.m_82129_((String)"item3", (ArgumentType)ItemArgument.m_120960_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"count3", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.deliverParcel((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.m_120963_((CommandContext)context, (String)"item1").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item2").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item3").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count3"), false)))).then(Commands.m_82129_((String)"item4", (ArgumentType)ItemArgument.m_120960_()).then(Commands.m_82129_((String)"count4", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ContactCommand.deliverParcel((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks"), StringArgumentType.getString((CommandContext)context, (String)"sender"), BoolArgumentType.getBool((CommandContext)context, (String)"isEnderType"), ItemArgument.m_120963_((CommandContext)context, (String)"item1").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count1"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item2").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count2"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item3").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count3"), false), ItemArgument.m_120963_((CommandContext)context, (String)"item4").m_120980_(IntegerArgumentType.getInteger((CommandContext)context, (String)"count4"), false))))))))))))))))));
    }

    private static void deliverToPlayerMailbox(CommandSourceStack source, String target, int ticks, AtomicInteger n, ItemStack parcel) {
        source.m_81377_().m_129880_(Level.f_46428_).getCapability(CapabilityRegistry.WORLD_MAILBOX_DATA).ifPresent(data -> {
            UUID uuid = data.getData().nameToUUID.get(target);
            if (uuid != null) {
                if (!data.getData().isMailboxFull(uuid)) {
                    data.getData().mailList.add(new MailToBeSent(uuid, parcel, ticks));
                    n.getAndIncrement();
                } else {
                    source.m_81354_((Component)new TranslatableComponent("command.contact.deliver.full", new Object[]{target}), true);
                }
            }
        });
    }

    private static int deliverParcel(CommandSourceStack source, String target, int ticks, String sender, boolean isEnder, ItemStack ... list) {
        AtomicInteger n = new AtomicInteger(0);
        ItemStackHandler contents = new ItemStackHandler(4);
        for (int i = 0; i < list.length; ++i) {
            contents.setStackInSlot(i, list[i]);
        }
        ItemStack parcel = ParcelItem.getParcel(contents, isEnder, sender);
        if (target.equals("@e")) {
            source.m_81377_().m_129880_(Level.f_46428_).getCapability(CapabilityRegistry.WORLD_MAILBOX_DATA).ifPresent(data -> data.getData().nameToUUID.keySet().forEach(name -> ContactCommand.deliverToPlayerMailbox(source, name, ticks, n, parcel)));
        } else {
            ContactCommand.deliverToPlayerMailbox(source, target, ticks, n, parcel);
        }
        if (n.get() == 1 && target.equals("@e")) {
            source.m_81354_((Component)new TranslatableComponent("command.contact.deliver.success.single", new Object[]{new ItemStack(isEnder ? (ItemLike)ItemRegistry.ENDER_PARCEL.get() : (ItemLike)ItemRegistry.PARCEL.get()).m_41611_(), target}), true);
        } else {
            source.m_81354_((Component)new TranslatableComponent("command.contact.deliver.success.multiple", new Object[]{new ItemStack(isEnder ? (ItemLike)ItemRegistry.ENDER_PARCEL.get() : (ItemLike)ItemRegistry.PARCEL.get()).m_41611_(), n.get()}), true);
        }
        return n.get();
    }

    private static int giveParcel(CommandSourceStack source, Collection<ServerPlayer> targets, String sender, boolean isEnder, ItemStack ... list) {
        ItemStackHandler contents = new ItemStackHandler(4);
        for (int i = 0; i < list.length; ++i) {
            contents.setStackInSlot(i, list[i]);
        }
        ItemStack parcel = ParcelItem.getParcel(contents, isEnder, sender);
        ContactCommand.giveParcelToPlayers(targets, parcel);
        if (targets.size() == 1) {
            source.m_81354_((Component)new TranslatableComponent("commands.give.success.single", new Object[]{1, new ItemStack(isEnder ? (ItemLike)ItemRegistry.ENDER_PARCEL.get() : (ItemLike)ItemRegistry.PARCEL.get()).m_41611_(), targets.iterator().next().m_5446_()}), true);
        } else {
            source.m_81354_((Component)new TranslatableComponent("commands.give.success.single", new Object[]{1, new ItemStack(isEnder ? (ItemLike)ItemRegistry.ENDER_PARCEL.get() : (ItemLike)ItemRegistry.PARCEL.get()).m_41611_(), targets.size()}), true);
        }
        return targets.size();
    }

    private static int deliverPostcard(CommandSourceStack source, ResourceLocation id, String target, int ticks, String sender, boolean isEnder, String text) {
        text = text.replace("\\n", "\n");
        AtomicInteger n = new AtomicInteger(0);
        if (target.equals("@e")) {
            ItemStack postcard = PostcardItem.setText(PostcardItem.getPostcard(id, isEnder), text);
            postcard.m_41784_().m_128359_("Sender", sender);
            source.m_81377_().m_129880_(Level.f_46428_).getCapability(CapabilityRegistry.WORLD_MAILBOX_DATA).ifPresent(data -> data.getData().nameToUUID.keySet().forEach(name -> ContactCommand.deliverToPlayerMailbox(source, name, ticks, n, postcard)));
        } else {
            ItemStack postcard = PostcardItem.setText(PostcardItem.getPostcard(id, false), text);
            postcard.m_41784_().m_128359_("Sender", sender);
            ContactCommand.deliverToPlayerMailbox(source, target, ticks, n, postcard);
        }
        if (n.get() == 1 && !target.equals("@e")) {
            source.m_81354_((Component)new TranslatableComponent("command.contact.deliver.success.single", new Object[]{new ItemStack(isEnder ? (ItemLike)ItemRegistry.ENDER_POSTCARD.get() : (ItemLike)ItemRegistry.POSTCARD.get()).m_41611_(), target}), true);
        } else {
            source.m_81354_((Component)new TranslatableComponent("command.contact.deliver.success.multiple", new Object[]{new ItemStack(isEnder ? (ItemLike)ItemRegistry.ENDER_POSTCARD.get() : (ItemLike)ItemRegistry.POSTCARD.get()).m_41611_(), n.get()}), true);
        }
        return n.get();
    }

    private static int givePostcard(CommandSourceStack source, ResourceLocation id, Collection<ServerPlayer> targets, String sender, boolean isEnder, String text) {
        ItemStack postcard;
        text = text.replace("\\n", "\n");
        if (sender.isEmpty()) {
            postcard = PostcardItem.getPostcard(id, isEnder);
        } else {
            postcard = PostcardItem.setText(PostcardItem.getPostcard(id, isEnder), text);
            postcard.m_41784_().m_128359_("Sender", sender);
        }
        ContactCommand.giveParcelToPlayers(targets, postcard);
        if (targets.size() == 1) {
            source.m_81354_((Component)new TranslatableComponent("commands.give.success.single", new Object[]{1, new ItemStack((ItemLike)ItemRegistry.POSTCARD.get()).m_41611_(), targets.iterator().next().m_5446_()}), true);
        } else {
            source.m_81354_((Component)new TranslatableComponent("commands.give.success.single", new Object[]{1, new ItemStack((ItemLike)ItemRegistry.POSTCARD.get()).m_41611_(), targets.size()}), true);
        }
        return targets.size();
    }

    private static void giveParcelToPlayers(Collection<ServerPlayer> targets, ItemStack parcel) {
        for (ServerPlayer serverplayer : targets) {
            boolean flag = serverplayer.m_150109_().m_36054_(parcel);
            if (flag) {
                ItemEntity itemEntity = serverplayer.m_36176_(parcel, false);
                if (itemEntity != null) {
                    itemEntity.m_32065_();
                }
                serverplayer.f_19853_.m_6263_(null, serverplayer.m_20185_(), serverplayer.m_20186_(), serverplayer.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((serverplayer.m_21187_().nextFloat() - serverplayer.m_21187_().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                serverplayer.f_36095_.m_38946_();
                continue;
            }
            ItemEntity itementity = serverplayer.m_36176_(parcel, false);
            if (itementity == null) continue;
            itementity.m_32061_();
            itementity.m_32047_(serverplayer.m_142081_());
        }
    }
}

