/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.contact.common.capability;

import cloud.lemonslice.contact.common.capability.MailToBeSent;
import cloud.lemonslice.contact.common.tileentity.MailboxBlockEntity;
import cloud.lemonslice.contact.network.ActionMessage;
import cloud.lemonslice.contact.network.SimpleNetworkHandler;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerMailboxData {
    public final Map<String, UUID> nameToUUID = Maps.newHashMap();
    public final Map<UUID, ItemStackHandler> uuidToContents = Maps.newHashMap();
    private final Map<UUID, GlobalPos> uuidToLocation = Maps.newHashMap();
    private final Map<GlobalPos, UUID> locationToPlayer = Maps.newHashMap();
    public final List<MailToBeSent> mailList = Lists.newArrayList();

    public ItemStackHandler getMailboxContents(UUID uuid) {
        return this.uuidToContents.getOrDefault(uuid, new ItemStackHandler(24));
    }

    public boolean isMailboxEmpty(UUID uuid) {
        ItemStackHandler contents = this.uuidToContents.get(uuid);
        if (contents == null) {
            return true;
        }
        for (int i = 0; i < contents.getSlots(); ++i) {
            if (contents.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean isMailboxFull(UUID uuid) {
        ItemStackHandler contents = this.uuidToContents.get(uuid);
        if (contents == null) {
            return false;
        }
        for (int i = 0; i < contents.getSlots(); ++i) {
            if (!contents.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean addMailboxContents(UUID uuid, ItemStack parcelIn) {
        ItemStackHandler mailbox = this.getMailboxContents(uuid);
        if (!this.isMailboxFull(uuid)) {
            for (int i = 0; i < mailbox.getSlots(); ++i) {
                if (!mailbox.getStackInSlot(i).m_41619_()) continue;
                mailbox.setStackInSlot(i, parcelIn);
                this.setMailboxContents(uuid, mailbox);
                ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(uuid);
                if (player != null) {
                    SimpleNetworkHandler.CHANNEL.sendTo((Object)new ActionMessage(0), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                }
                return true;
            }
        }
        return false;
    }

    public void setMailboxContents(UUID uuid, ItemStackHandler contents) {
        this.uuidToContents.put(uuid, contents);
    }

    public void resetMailboxContents(UUID uuid) {
        this.setMailboxContents(uuid, new ItemStackHandler(24));
    }

    @Nullable
    public UUID getMailboxOwner(ResourceKey<Level> world, BlockPos pos) {
        return this.locationToPlayer.get(GlobalPos.m_122643_(world, (BlockPos)pos));
    }

    @Nullable
    public GlobalPos getMailboxPos(UUID uuid) {
        return this.uuidToLocation.get(uuid);
    }

    public void setMailboxData(UUID uuid, ResourceKey<Level> world, BlockPos pos) {
        BlockEntity newTE;
        GlobalPos newPos = GlobalPos.m_122643_(world, (BlockPos)pos);
        GlobalPos oldPos = this.uuidToLocation.get(uuid);
        if (oldPos != null) {
            BlockEntity oldTE;
            this.locationToPlayer.remove(oldPos);
            ServerLevel oldWorld = ServerLifecycleHooks.getCurrentServer().m_129880_(oldPos.m_122640_());
            if (oldWorld != null && oldWorld.isAreaLoaded(oldPos.m_122646_(), 1) && (oldTE = oldWorld.m_7702_(oldPos.m_122646_())) instanceof MailboxBlockEntity) {
                ((MailboxBlockEntity)oldTE).refreshStatus();
            }
        }
        this.uuidToLocation.put(uuid, newPos);
        this.locationToPlayer.put(newPos, uuid);
        ServerLevel newWorld = ServerLifecycleHooks.getCurrentServer().m_129880_(world);
        if (newWorld != null && newWorld.isAreaLoaded(newPos.m_122646_(), 1) && (newTE = newWorld.m_7702_(newPos.m_122646_())) instanceof MailboxBlockEntity) {
            ((MailboxBlockEntity)newTE).refreshStatus();
        }
    }

    public void removeMailboxData(GlobalPos pos) {
        GlobalPos mailboxPos;
        UUID uuid = this.locationToPlayer.remove(pos);
        if (uuid != null && Objects.equals(mailboxPos = this.uuidToLocation.get(uuid), pos)) {
            this.uuidToLocation.remove(uuid);
        }
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        int n = this.uuidToContents.keySet().size();
        nbt.m_128405_("MapDataSize", n);
        int i = 0;
        for (UUID uuid : this.uuidToContents.keySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("UUID", uuid.toString());
            tag.m_128365_("Contents", (Tag)this.uuidToContents.getOrDefault(uuid, new ItemStackHandler(24)).serializeNBT());
            GlobalPos globalPos = this.uuidToLocation.get(uuid);
            if (globalPos != null) {
                ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)globalPos.m_122640_().m_135782_()).resultOrPartial(arg_0 -> ((Logger)LogManager.getLogger()).error(arg_0)).ifPresent(world -> tag.m_128365_("MailboxDimension", world));
                tag.m_128405_("MailboxX", globalPos.m_122646_().m_123341_());
                tag.m_128405_("MailboxY", globalPos.m_122646_().m_123342_());
                tag.m_128405_("MailboxZ", globalPos.m_122646_().m_123343_());
            }
            nbt.m_128365_("MapData" + i, (Tag)tag);
            ++i;
        }
        nbt.m_128405_("MailListSize", this.mailList.size());
        for (i = 0; i < this.mailList.size(); ++i) {
            nbt.m_128365_("MailListData" + i, (Tag)this.mailList.get(i).writeToNBT());
        }
        nbt.m_128405_("NameMapSize", this.nameToUUID.keySet().size());
        i = 0;
        for (String name : this.nameToUUID.keySet()) {
            nbt.m_128359_("NameMap" + i, name);
            nbt.m_128359_("NameMapUUID" + i, this.nameToUUID.get(name).toString());
            ++i;
        }
        return nbt;
    }

    public void readFromNBT(CompoundTag nbt) {
        UUID uuid;
        CompoundTag tag;
        int i;
        this.uuidToContents.clear();
        this.uuidToLocation.clear();
        this.locationToPlayer.clear();
        this.mailList.clear();
        this.nameToUUID.clear();
        int n = nbt.m_128451_("MapDataSize");
        for (i = 0; i < n; ++i) {
            tag = nbt.m_128469_("MapData" + i);
            uuid = UUID.fromString(tag.m_128461_("UUID"));
            ItemStackHandler contents = new ItemStackHandler(24);
            contents.deserializeNBT(tag.m_128469_("Contents"));
            this.uuidToContents.put(uuid, contents);
            if (!tag.m_128441_("MailboxDimension")) continue;
            BlockPos mailboxPos = new BlockPos(tag.m_128451_("MailboxX"), tag.m_128451_("MailboxY"), tag.m_128451_("MailboxZ"));
            ResourceKey mailboxWorld = Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("MailboxDimension")).resultOrPartial(arg_0 -> ((Logger)LogManager.getLogger()).error(arg_0)).orElse(Level.f_46428_);
            GlobalPos globalPos = GlobalPos.m_122643_((ResourceKey)mailboxWorld, (BlockPos)mailboxPos);
            this.uuidToLocation.put(uuid, globalPos);
            this.locationToPlayer.put(globalPos, uuid);
        }
        n = nbt.m_128451_("MailListSize");
        for (i = 0; i < n; ++i) {
            tag = nbt.m_128469_("MailListData" + i);
            MailToBeSent mail = new MailToBeSent(tag);
            this.mailList.add(mail);
        }
        n = nbt.m_128451_("NameMapSize");
        for (i = 0; i < n; ++i) {
            String name = nbt.m_128461_("NameMap" + i);
            uuid = UUID.fromString(nbt.m_128461_("NameMapUUID" + i));
            this.nameToUUID.put(name, uuid);
        }
    }
}

