/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.contact.common.capability;

import cloud.lemonslice.contact.common.capability.CapabilityRegistry;
import cloud.lemonslice.contact.common.capability.IMailboxDataStorage;
import cloud.lemonslice.contact.common.capability.PlayerMailboxData;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class MailboxDataStorage
implements IMailboxDataStorage,
INBTSerializable<Tag> {
    public final PlayerMailboxData PLAYERS_DATA = new PlayerMailboxData();

    @Override
    public PlayerMailboxData getData() {
        return this.PLAYERS_DATA;
    }

    public Tag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        this.PLAYERS_DATA.writeToNBT(compound);
        return compound;
    }

    public void deserializeNBT(Tag nbt) {
        this.PLAYERS_DATA.readFromNBT((CompoundTag)nbt);
    }

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        private final LazyOptional<MailboxDataStorage> data = LazyOptional.of(MailboxDataStorage::new);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (Objects.equals(cap, CapabilityRegistry.WORLD_MAILBOX_DATA)) {
                return this.data.cast();
            }
            return LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return ((MailboxDataStorage)this.data.orElseGet(MailboxDataStorage::new)).serializeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            ((MailboxDataStorage)this.data.orElseGet(MailboxDataStorage::new)).deserializeNBT(nbt);
        }
    }
}

