/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.contact.common.capability;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class MailToBeSent {
    private UUID uuid;
    private final ItemStackHandler contents;
    private long ticks;

    public MailToBeSent(CompoundTag nbt) {
        this.uuid = UUID.fromString(nbt.m_128461_("MailUUID"));
        this.ticks = nbt.m_128451_("MailTicks");
        this.contents = new ItemStackHandler();
        this.contents.deserializeNBT(nbt.m_128469_("MailContents"));
    }

    public MailToBeSent(UUID uuid, ItemStack contents, long ticks) {
        this.uuid = uuid;
        this.contents = new ItemStackHandler();
        this.contents.setStackInSlot(0, contents.m_41777_());
        this.ticks = ticks;
    }

    public ItemStack getContents() {
        return this.contents.getStackInSlot(0).m_41777_();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isReady() {
        return this.ticks <= 0L;
    }

    public void tick(int tick) {
        if (this.ticks > 0L) {
            this.ticks -= (long)tick;
        }
    }

    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("MailUUID", this.uuid.toString());
        nbt.m_128356_("MailTicks", this.ticks);
        nbt.m_128365_("MailContents", (Tag)this.contents.serializeNBT());
        return nbt;
    }

    public void readFromNBT(CompoundTag nbt) {
        this.uuid = UUID.fromString(nbt.m_128461_("MailUUID"));
        this.ticks = nbt.m_128454_("MailTicks");
        this.contents.deserializeNBT(nbt.m_128469_("MailContents"));
    }
}

