/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.contact.common.block;

import cloud.lemonslice.contact.common.capability.CapabilityRegistry;
import cloud.lemonslice.contact.common.handler.AdvancementManager;
import cloud.lemonslice.contact.common.handler.MailboxManager;
import cloud.lemonslice.contact.common.item.IMailItem;
import cloud.lemonslice.contact.common.item.PostcardItem;
import cloud.lemonslice.contact.common.tileentity.BlockEntityTypeRegistry;
import cloud.lemonslice.contact.common.tileentity.MailboxBlockEntity;
import cloud.lemonslice.silveroak.common.block.NormalHorizontalBlock;
import cloud.lemonslice.silveroak.helper.VoxelShapeHelper;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.server.ServerLifecycleHooks;

public class MailboxBlock
extends NormalHorizontalBlock
implements EntityBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public final DyeColor boxColor;
    public final DyeColor flagColor;
    public static final VoxelShape LOWER_SHAPE = VoxelShapeHelper.createVoxelShape((double)7.0, (double)0.0, (double)7.0, (double)2.0, (double)16.0, (double)2.0);
    public static final VoxelShape UPPER_SHAPE_NORTH = VoxelShapeHelper.createVoxelShape((double)3.0, (double)0.0, (double)1.0, (double)10.0, (double)9.0, (double)14.0);
    public static final VoxelShape UPPER_SHAPE_EAST = VoxelShapeHelper.createVoxelShape((double)1.0, (double)0.0, (double)3.0, (double)14.0, (double)9.0, (double)10.0);

    public MailboxBlock(DyeColor boxColor, DyeColor flagColor) {
        super(BlockBehaviour.Properties.m_60941_((Material)Material.f_76278_, (DyeColor)boxColor).m_60955_().m_60918_(SoundType.f_56742_).m_60913_(1.5f, 6.0f));
        this.boxColor = boxColor;
        this.flagColor = flagColor;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public MailboxBlock(DyeColor boxColor) {
        this(boxColor, DyeColor.RED);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((DoubleBlockHalf)state.m_61143_(HALF)).equals((Object)DoubleBlockHalf.LOWER)) {
            return LOWER_SHAPE;
        }
        switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case EAST: 
            case WEST: {
                return UPPER_SHAPE_EAST;
            }
        }
        return UPPER_SHAPE_NORTH;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HALF, OPEN});
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.m_61143_(HALF);
        if (facing.m_122434_() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            return facingState.m_60713_((Block)this) && facingState.m_61143_(HALF) != doubleblockhalf ? (BlockState)stateIn.m_61124_((Property)f_54117_, (Comparable)((Direction)facingState.m_61143_((Property)f_54117_))) : Blocks.f_50016_.m_49966_();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected static void removeBottomHalf(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = world.m_8055_(blockpos = pos.m_7495_())).m_60734_() == state.m_60734_() && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            world.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            world.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!worldIn.f_46443_) {
            return worldIn.m_142572_().m_129880_(Level.f_46428_).getCapability(CapabilityRegistry.WORLD_MAILBOX_DATA).map(data -> {
                BlockPos topPos = state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? pos : pos.m_7494_();
                UUID mailboxOwner = data.getData().getMailboxOwner((ResourceKey<Level>)worldIn.m_46472_(), topPos);
                if (player.m_6144_() && mailboxOwner == null) {
                    if (data.getData().getMailboxPos(player.m_142081_()) == null) {
                        player.m_5661_((Component)new TranslatableComponent("message.contact.mailbox.binding"), false);
                    } else {
                        player.m_5661_((Component)new TranslatableComponent("message.contact.mailbox.switch"), false);
                    }
                    data.getData().setMailboxData(player.m_142081_(), (ResourceKey<Level>)worldIn.m_46472_(), topPos);
                    MailboxManager.updateState(worldIn, topPos);
                    AdvancementManager.givePlayerAdvancement(worldIn.m_142572_(), (ServerPlayer)player, new ResourceLocation("contact:root"));
                    return InteractionResult.SUCCESS;
                }
                if (Objects.equals(mailboxOwner, player.m_142081_())) {
                    ItemStackHandler contents = data.getData().getMailboxContents(mailboxOwner);
                    boolean isEmpty = true;
                    for (int i = 0; i < contents.getSlots(); ++i) {
                        ItemStack parcel = contents.getStackInSlot(i);
                        if (parcel.m_41619_()) continue;
                        if (parcel.m_41720_() instanceof PostcardItem) {
                            AdvancementManager.givePlayerAdvancement(worldIn.m_142572_(), (ServerPlayer)player, new ResourceLocation("contact:receive_postcard"));
                        }
                        if (parcel.m_41784_().m_128441_("AnotherLevel")) {
                            AdvancementManager.givePlayerAdvancement(worldIn.m_142572_(), (ServerPlayer)player, new ResourceLocation("contact:from_another_world"));
                        }
                        player.m_150109_().m_150079_(parcel);
                        isEmpty = false;
                    }
                    data.getData().resetMailboxContents(mailboxOwner);
                    if (!isEmpty) {
                        player.m_5661_((Component)new TranslatableComponent("message.contact.mailbox.pick_up"), false);
                    } else {
                        player.m_5661_((Component)new TranslatableComponent("message.contact.mailbox.empty"), false);
                    }
                    MailboxManager.updateState(worldIn, topPos);
                    return InteractionResult.SUCCESS;
                }
                if (player.m_21120_(handIn).m_41720_() instanceof IMailItem) {
                    if (mailboxOwner != null) {
                        if (data.getData().isMailboxEmpty(mailboxOwner)) {
                            ItemStack held = player.m_21120_(handIn).m_41777_();
                            held.m_41784_().m_128359_("Sender", player.m_7755_().getString());
                            data.getData().addMailboxContents(mailboxOwner, held);
                            player.m_21008_(handIn, ItemStack.f_41583_);
                            player.m_5661_((Component)new TranslatableComponent("message.contact.mailbox.deliver"), false);
                            AdvancementManager.givePlayerAdvancement(player.m_20194_(), (ServerPlayer)player, new ResourceLocation("contact:send_in_person"));
                            MailboxManager.updateState(worldIn, topPos);
                        } else {
                            player.m_5661_((Component)new TranslatableComponent("message.contact.mailbox.full"), false);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    player.m_5661_((Component)new TranslatableComponent("message.contact.mailbox.no_owner"), false);
                    return InteractionResult.SUCCESS;
                }
                if (mailboxOwner != null) {
                    ServerLifecycleHooks.getCurrentServer().m_129927_().m_11002_(mailboxOwner).ifPresent(gameProfile -> player.m_5661_((Component)new TranslatableComponent("message.contact.mailbox.others", new Object[]{gameProfile.getName()}), false));
                    return InteractionResult.SUCCESS;
                }
                player.m_5661_((Component)new TranslatableComponent("message.contact.mailbox.no_owner_tips"), false);
                return InteractionResult.FAIL;
            }).orElse(InteractionResult.FAIL);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.f_46443_) {
            if (player.m_7500_()) {
                MailboxBlock.removeBottomHalf(worldIn, pos, state, player);
            }
            worldIn.m_142572_().m_129880_(Level.f_46428_).getCapability(CapabilityRegistry.WORLD_MAILBOX_DATA).ifPresent(data -> {
                BlockPos topPos = state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? pos : pos.m_7494_();
                data.getData().removeMailboxData(GlobalPos.m_122643_((ResourceKey)worldIn.m_46472_(), (BlockPos)topPos));
            });
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        if (blockpos.m_123342_() < 255 && context.m_43725_().m_8055_(blockpos.m_7494_()).m_60629_(context)) {
            return (BlockState)super.m_5573_(context).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = worldIn.m_8055_(blockpos);
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? blockstate.m_60783_((BlockGetter)worldIn, blockpos, Direction.UP) : blockstate.m_60713_((Block)this);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return MailboxBlock.createTickerHelper(pBlockEntityType, MailboxBlockEntity::tick);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> blockEntityType, BlockEntityTicker<? super E> entityTicker) {
        return BlockEntityTypeRegistry.MAILBOX_BLOCK_ENTITY.get() == blockEntityType ? entityTicker : null;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this)}) : Collections.emptyList();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)BlockEntityTypeRegistry.MAILBOX_BLOCK_ENTITY.get()).m_155264_(pPos, pState);
    }
}

