/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.contact.client.gui;

import cloud.lemonslice.contact.common.container.ContainerTypeRegistry;
import cloud.lemonslice.contact.common.container.PostboxContainer;
import cloud.lemonslice.contact.network.EnquireAddresseeMessage;
import cloud.lemonslice.contact.network.SimpleNetworkHandler;
import cloud.lemonslice.silveroak.client.texture.TexturePos;
import cloud.lemonslice.silveroak.client.widget.IconButton;
import cloud.lemonslice.silveroak.helper.GuiHelper;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class PostboxGui
extends AbstractContainerScreen<PostboxContainer> {
    private static final ResourceLocation RED_TEXTURE = new ResourceLocation("contact", "textures/gui/red_postbox.png");
    private static final ResourceLocation GREEN_TEXTURE = new ResourceLocation("contact", "textures/gui/green_postbox.png");
    private final boolean isRed;
    private int offsetX;
    private int offsetY;
    private IconButton buttonSend;
    private EditBox nameField;

    public PostboxGui(PostboxContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.f_97727_ = 133;
        this.isRed = screenContainer.m_6772_() == ContainerTypeRegistry.RED_POSTBOX_CONTAINER.get();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.offsetX = (this.f_96543_ - this.f_97726_) / 2;
        this.offsetY = (this.f_96544_ - this.f_97727_) / 2;
        this.buttonSend = (IconButton)this.m_7787_((GuiEventListener)new IconButton(this.offsetX + 97, this.offsetY + 26, 10, 9, (Component)new TranslatableComponent("tooltip.contact.postbox.send"), button -> this.send(), this::buttonTooltip));
        this.f_96541_.f_91068_.m_90926_(true);
        this.nameField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.offsetX + 42, this.offsetY + 26, 43, 9, (Component)new TranslatableComponent("info.contact.postbox.addressee")));
        this.nameField.m_94202_(-1);
        this.nameField.m_94205_(-1);
        this.nameField.m_94144_(((PostboxContainer)this.f_97732_).playerName);
        this.nameField.m_94151_(this::whileTyping);
        this.nameField.m_94182_(false);
        this.nameField.m_94199_(64);
        this.m_94718_((GuiEventListener)this.nameField);
    }

    private void buttonTooltip(Button button, PoseStack poseStack, int mouseX, int mouseY) {
        if (button.m_198029_()) {
            if (((PostboxContainer)this.f_97732_).status == 2) {
                GuiHelper.drawTooltip((Screen)this, (PoseStack)poseStack, (int)mouseX, (int)mouseY, (int)button.f_93620_, (int)button.f_93621_, (int)button.m_5711_(), (int)button.m_93694_(), (List)Lists.newArrayList((Object[])new Component[]{button.m_6035_()}));
            } else {
                GuiHelper.drawTooltip((Screen)this, (PoseStack)poseStack, (int)mouseX, (int)mouseY, (int)button.f_93620_, (int)button.f_93621_, (int)button.m_5711_(), (int)button.m_93694_(), (List)Lists.newArrayList((Object[])new Component[]{new TranslatableComponent("tooltip.contact.postbox.enquire")}));
            }
        }
    }

    private void whileTyping(String name) {
        if (!((PostboxContainer)this.f_97732_).playerName.equals(name)) {
            ((PostboxContainer)this.f_97732_).playerName = name;
            if (((PostboxContainer)this.f_97732_).status > 1) {
                ((PostboxContainer)this.f_97732_).status = 1;
            }
        }
    }

    private void send() {
        if (((PostboxContainer)this.f_97732_).status == 2) {
            SimpleNetworkHandler.CHANNEL.sendToServer((Object)new EnquireAddresseeMessage(((PostboxContainer)this.f_97732_).playerName, true));
        } else if (((PostboxContainer)this.f_97732_).status == 5) {
            ((PostboxContainer)this.f_97732_).status = 0;
        } else if (((PostboxContainer)this.f_97732_).status != 0) {
            SimpleNetworkHandler.CHANNEL.sendToServer((Object)new EnquireAddresseeMessage(((PostboxContainer)this.f_97732_).playerName, false));
        }
        this.nameField.m_94178_(false);
    }

    public void m_181908_() {
        super.m_181908_();
        this.nameField.m_94120_();
        if (((PostboxContainer)this.f_97732_).status == 2 && !this.nameField.m_94155_().equals(((PostboxContainer)this.f_97732_).playerName)) {
            this.nameField.m_94144_(((PostboxContainer)this.f_97732_).playerName);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int x, int y) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceLocation texture = this.isRed ? RED_TEXTURE : GREEN_TEXTURE;
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        GuiHelper.drawLayer((PoseStack)poseStack, (int)this.offsetX, (int)this.offsetY, (TexturePos)new TexturePos(0, 0, this.f_97726_, this.f_97727_));
        GuiHelper.renderButton((PoseStack)poseStack, (float)partialTicks, (int)x, (int)y, (int)this.m_93252_(), (ResourceLocation)texture, (Button)this.buttonSend, (TexturePos)new TexturePos(this.f_97726_, 0, 10, 9), (TexturePos)new TexturePos(this.f_97726_, 9, 10, 9));
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("info.contact.postbox.addressee"), 40.0f, 14.0f, 0xE6E6E6);
        switch (((PostboxContainer)this.f_97732_).status) {
            case 0: {
                TranslatableComponent text = new TranslatableComponent("info.contact.postbox.need_mail");
                this.renderTipsSentOrFull(poseStack, text);
                return;
            }
            case 2: {
                TranslatableComponent text = new TranslatableComponent("info.contact.postbox.estimated");
                int width = this.f_96547_.m_92895_(text.getString());
                int min = ((PostboxContainer)this.f_97732_).time / 1200;
                int sec = ((PostboxContainer)this.f_97732_).time % 1200 / 20;
                if (width > 38) {
                    this.f_96547_.m_92889_(poseStack, (Component)text, (float)(141 - width / 2), 10.0f, 0x1A1A1A);
                    if (((PostboxContainer)this.f_97732_).time == 0) {
                        this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("info.contact.postbox.instant"), (float)(141 - width / 2), 22.0f, 0x1A1A1A);
                    } else {
                        this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("info.contact.postbox.time", new Object[]{min, sec}), (float)(141 - width / 2), 22.0f, 0x1A1A1A);
                    }
                } else {
                    this.f_96547_.m_92889_(poseStack, (Component)text, 122.0f, 10.0f, 0x1A1A1A);
                    if (((PostboxContainer)this.f_97732_).time == 0) {
                        this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("info.contact.postbox.instant"), 122.0f, 22.0f, 0x1A1A1A);
                    } else {
                        this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("info.contact.postbox.time", new Object[]{min, sec}), 122.0f, 22.0f, 0x1A1A1A);
                    }
                }
                return;
            }
            case 3: {
                TranslatableComponent text = new TranslatableComponent("info.contact.postbox.not_found");
                int width = this.f_96547_.m_92895_(text.getString());
                if (width > 38) {
                    this.f_96547_.m_92889_(poseStack, (Component)text, (float)(141 - width / 2), 16.0f, 0x1A1A1A);
                } else {
                    this.f_96547_.m_92889_(poseStack, (Component)text, 122.0f, 16.0f, 0x1A1A1A);
                }
                return;
            }
            case 4: {
                TranslatableComponent text = new TranslatableComponent("info.contact.postbox.full_mail");
                this.renderTipsSentOrFull(poseStack, text);
                return;
            }
            case 5: {
                TranslatableComponent text = new TranslatableComponent("info.contact.postbox.success");
                this.renderTipsSentOrFull(poseStack, text);
            }
        }
    }

    private void renderTipsSentOrFull(PoseStack poseStack, TranslatableComponent text) {
        int width = this.f_96547_.m_92895_(text.getString());
        if (width > 38) {
            List list = this.f_96547_.m_92923_((FormattedText)text, 50);
            for (int i = 0; i < list.size(); ++i) {
                this.f_96547_.m_92877_(poseStack, (FormattedCharSequence)list.get(i), 118.0f, (float)(22 - list.size() * 6 + i * 12), 0x1A1A1A);
            }
        } else {
            this.f_96547_.m_92889_(poseStack, (Component)text, 122.0f, 16.0f, 0x1A1A1A);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.f_96541_.f_91074_.m_6915_();
        }
        return this.nameField.m_7933_(keyCode, scanCode, modifiers) || this.nameField.m_94204_() || super.m_7933_(keyCode, scanCode, modifiers);
    }
}

