/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.block.entity;

import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.util.control.IReconfigurableTile;
import cofh.core.util.control.ITransferControllableTile;
import cofh.core.util.control.ReconfigControlModule;
import cofh.core.util.control.TransferControlModule;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.InventoryHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.api.control.IReconfigurable;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.Constants;
import cofh.lib.util.constants.BlockStatePropertiesCoFH;
import cofh.lib.util.helpers.BlockHelper;
import cofh.thermal.lib.block.entity.AugmentableBlockEntity;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class Reconfigurable4WayBlockEntity
extends AugmentableBlockEntity
implements IReconfigurableTile,
ITransferControllableTile,
IThermalInventory {
    protected int inputTracker;
    protected int outputTracker;
    protected ReconfigControlModule reconfigControl = new ReconfigControlModule((IReconfigurableTile)this);
    protected TransferControlModule transferControl = new TransferControlModule((ITransferControllableTile)this);
    protected boolean reconfigControlFeature = this.defaultReconfigState();
    protected LazyOptional<?> inputItemCap = LazyOptional.empty();
    protected LazyOptional<?> outputItemCap = LazyOptional.empty();
    protected LazyOptional<?> ioItemCap = LazyOptional.empty();
    protected LazyOptional<?> inputFluidCap = LazyOptional.empty();
    protected LazyOptional<?> outputFluidCap = LazyOptional.empty();
    protected LazyOptional<?> ioFluidCap = LazyOptional.empty();

    public Reconfigurable4WayBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.reconfigControl.setEnabled(() -> this.reconfigControlFeature);
        this.transferControl.setEnabled(() -> this.reconfigControlFeature);
        this.reconfigControl.setFacing((Direction)state.m_61143_((Property)BlockStatePropertiesCoFH.FACING_HORIZONTAL));
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        this.updateHandlers();
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        this.updateSideCache();
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        this.inputItemCap.invalidate();
        this.outputItemCap.invalidate();
        this.inputFluidCap.invalidate();
        this.outputFluidCap.invalidate();
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ModelUtils.SIDES, (Object)this.reconfigControl().getRawSideConfig()).withInitial(ModelUtils.FLUID, (Object)this.renderFluid).build();
    }

    public List<? extends ItemStorageCoFH> inputSlots() {
        return this.inventory.getInputSlots();
    }

    public List<? extends FluidStorageCoFH> inputTanks() {
        return this.tankInv.getInputTanks();
    }

    protected List<? extends ItemStorageCoFH> outputSlots() {
        return this.inventory.getOutputSlots();
    }

    protected List<? extends FluidStorageCoFH> outputTanks() {
        return this.tankInv.getOutputTanks();
    }

    protected void updateSideCache() {
        Direction curFacing;
        Direction prevFacing = this.getFacing();
        if (prevFacing != (curFacing = (Direction)this.m_58900_().m_61143_((Property)BlockStatePropertiesCoFH.FACING_HORIZONTAL))) {
            this.reconfigControl.setFacing(curFacing);
            int iPrev = prevFacing.m_122411_();
            int iFace = curFacing.m_122411_();
            IReconfigurable.SideConfig[] sides = new IReconfigurable.SideConfig[6];
            if (iPrev == BlockHelper.SIDE_RIGHT[iFace]) {
                for (int i = 0; i < 6; ++i) {
                    sides[i] = this.reconfigControl.getSideConfig()[BlockHelper.ROTATE_CLOCK_Y[i]];
                }
            } else if (iPrev == BlockHelper.SIDE_LEFT[iFace]) {
                for (int i = 0; i < 6; ++i) {
                    sides[i] = this.reconfigControl.getSideConfig()[BlockHelper.ROTATE_COUNTER_Y[i]];
                }
            } else if (iPrev == BlockHelper.SIDE_OPPOSITE[iFace]) {
                for (int i = 0; i < 6; ++i) {
                    sides[i] = this.reconfigControl.getSideConfig()[BlockHelper.INVERT_AROUND_Y[i]];
                }
            }
            this.reconfigControl.setSideConfig(sides);
        }
        this.updateHandlers();
    }

    protected void transferInput() {
        if (!this.transferControl.getTransferIn()) {
            return;
        }
        int newTracker = this.inputTracker;
        boolean updateTracker = false;
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            Direction side = Constants.DIRECTIONS[i % 6];
            if (!this.reconfigControl.getSideConfig(side).isInput()) continue;
            for (ItemStorageCoFH itemStorageCoFH : this.inputSlots()) {
                if (itemStorageCoFH.getSpace() <= 0) continue;
                InventoryHelper.extractFromAdjacent((BlockEntity)this, (ItemStorageCoFH)itemStorageCoFH, (int)Math.min(this.getInputItemAmount(), itemStorageCoFH.getSpace()), (Direction)side);
            }
            for (FluidStorageCoFH fluidStorageCoFH : this.inputTanks()) {
                if (fluidStorageCoFH.getSpace() <= 0) continue;
                FluidHelper.extractFromAdjacent((BlockEntity)this, (FluidStorageCoFH)fluidStorageCoFH, (int)Math.min(this.getInputFluidAmount(), fluidStorageCoFH.getSpace()), (Direction)side);
            }
            if (updateTracker) continue;
            newTracker = side.ordinal();
            updateTracker = true;
        }
        this.inputTracker = newTracker;
    }

    protected void transferOutput() {
        if (!this.transferControl.getTransferOut()) {
            return;
        }
        int newTracker = this.outputTracker;
        boolean updateTracker = false;
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            Direction side = Constants.DIRECTIONS[i % 6];
            if (!this.reconfigControl.getSideConfig(side).isOutput()) continue;
            for (ItemStorageCoFH itemStorageCoFH : this.outputSlots()) {
                InventoryHelper.insertIntoAdjacent((BlockEntity)this, (ItemStorageCoFH)itemStorageCoFH, (int)this.getOutputItemAmount(), (Direction)side);
            }
            for (FluidStorageCoFH fluidStorageCoFH : this.outputTanks()) {
                FluidHelper.insertIntoAdjacent((BlockEntity)this, (FluidStorageCoFH)fluidStorageCoFH, (int)this.getOutputFluidAmount(), (Direction)side);
            }
            if (updateTracker) continue;
            newTracker = side.ordinal();
            updateTracker = true;
        }
        this.outputTracker = newTracker;
    }

    protected int getInputItemAmount() {
        return 64;
    }

    protected int getOutputItemAmount() {
        return 64;
    }

    protected int getInputFluidAmount() {
        return 1000;
    }

    protected int getOutputFluidAmount() {
        return 1000;
    }

    @Override
    public void neighborChanged(Block blockIn, BlockPos fromPos) {
        super.neighborChanged(blockIn, fromPos);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        ModelDataManager.requestModelDataRefresh((BlockEntity)this);
    }

    @Override
    public FriendlyByteBuf getControlPacket(FriendlyByteBuf buffer) {
        super.getControlPacket(buffer);
        this.reconfigControl.writeToBuffer(buffer);
        this.transferControl.writeToBuffer(buffer);
        return buffer;
    }

    @Override
    public void handleControlPacket(FriendlyByteBuf buffer) {
        super.handleControlPacket(buffer);
        this.reconfigControl.readFromBuffer(buffer);
        this.transferControl.readFromBuffer(buffer);
        ModelDataManager.requestModelDataRefresh((BlockEntity)this);
    }

    @Override
    public void handleStatePacket(FriendlyByteBuf buffer) {
        super.handleStatePacket(buffer);
        ModelDataManager.requestModelDataRefresh((BlockEntity)this);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.reconfigControl.setFacing(Direction.m_122376_((int)nbt.m_128445_("Facing")));
        this.reconfigControl.read(nbt);
        this.transferControl.read(nbt);
        this.inputTracker = nbt.m_128451_("TrackIn");
        this.outputTracker = nbt.m_128451_("TrackOut");
        this.updateHandlers();
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128344_("Facing", (byte)this.reconfigControl.getFacing().m_122411_());
        this.reconfigControl.write(nbt);
        this.transferControl.write(nbt);
        nbt.m_128405_("TrackIn", this.inputTracker);
        nbt.m_128405_("TrackOut", this.outputTracker);
    }

    @Override
    protected void resetAttributes() {
        super.resetAttributes();
        this.reconfigControlFeature = this.defaultReconfigState();
    }

    @Override
    protected void setAttributesFromAugment(CompoundTag augmentData) {
        super.setAttributesFromAugment(augmentData);
        this.reconfigControlFeature |= AugmentableHelper.getAttributeMod((CompoundTag)augmentData, (String)"SideCfg") > 0.0f;
    }

    @Override
    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        super.finalizeAttributes(enchantmentMap);
        if (!this.reconfigControlFeature) {
            this.transferControl.disable();
            this.reconfigControl.disable();
        }
    }

    public ReconfigControlModule reconfigControl() {
        return this.reconfigControl;
    }

    public TransferControlModule transferControl() {
        return this.transferControl;
    }

    @Override
    protected void updateHandlers() {
        super.updateHandlers();
        LazyOptional<?> prevItemInputCap = this.inputItemCap;
        LazyOptional<?> prevItemOutputCap = this.outputItemCap;
        LazyOptional<?> prevItemIOCap = this.ioItemCap;
        IItemHandler inputInvHandler = this.inventory.getHandler(StorageGroup.INPUT);
        IItemHandler outputInvHandler = this.inventory.getHandler(StorageGroup.OUTPUT);
        IItemHandler ioInvHandler = this.inventory.getHandler(StorageGroup.INPUT_OUTPUT);
        this.inputItemCap = this.inventory.hasInputSlots() ? LazyOptional.of(() -> inputInvHandler) : LazyOptional.empty();
        this.outputItemCap = this.inventory.hasOutputSlots() ? LazyOptional.of(() -> outputInvHandler) : LazyOptional.empty();
        this.ioItemCap = this.inventory.hasAccessibleSlots() ? LazyOptional.of(() -> ioInvHandler) : LazyOptional.empty();
        prevItemInputCap.invalidate();
        prevItemOutputCap.invalidate();
        prevItemIOCap.invalidate();
        LazyOptional<?> prevFluidInputCap = this.inputFluidCap;
        LazyOptional<?> prevFluidOutputCap = this.outputFluidCap;
        LazyOptional<?> prevFluidIOCap = this.ioFluidCap;
        IFluidHandler inputFluidHandler = this.tankInv.getHandler(StorageGroup.INPUT);
        IFluidHandler outputFluidHandler = this.tankInv.getHandler(StorageGroup.OUTPUT);
        IFluidHandler ioFluidHandler = this.tankInv.getHandler(StorageGroup.INPUT_OUTPUT);
        this.inputFluidCap = this.tankInv.hasInputTanks() ? LazyOptional.of(() -> inputFluidHandler) : LazyOptional.empty();
        this.outputFluidCap = this.tankInv.hasOutputTanks() ? LazyOptional.of(() -> outputFluidHandler) : LazyOptional.empty();
        this.ioFluidCap = this.tankInv.hasAccessibleTanks() ? LazyOptional.of(() -> ioFluidHandler) : LazyOptional.empty();
        prevFluidInputCap.invalidate();
        prevFluidOutputCap.invalidate();
        prevFluidIOCap.invalidate();
    }

    @Override
    protected <T> LazyOptional<T> getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return super.getItemHandlerCapability(side);
        }
        switch (this.reconfigControl.getSideConfig(side)) {
            case SIDE_NONE: {
                return LazyOptional.empty();
            }
            case SIDE_INPUT: {
                return this.inputItemCap.cast();
            }
            case SIDE_OUTPUT: {
                return this.outputItemCap.cast();
            }
            case SIDE_BOTH: {
                return this.ioItemCap.cast();
            }
            case SIDE_ACCESSIBLE: {
                if (this.reconfigControl.isReconfigurable()) break;
                return this.ioItemCap.cast();
            }
        }
        return super.getItemHandlerCapability(side);
    }

    @Override
    protected <T> LazyOptional<T> getFluidHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return super.getFluidHandlerCapability(side);
        }
        switch (this.reconfigControl.getSideConfig(side)) {
            case SIDE_NONE: {
                return LazyOptional.empty();
            }
            case SIDE_INPUT: {
                return this.inputFluidCap.cast();
            }
            case SIDE_OUTPUT: {
                return this.outputFluidCap.cast();
            }
            case SIDE_BOTH: {
                return this.ioFluidCap.cast();
            }
            case SIDE_ACCESSIBLE: {
                if (this.reconfigControl.isReconfigurable()) break;
                return this.ioFluidCap.cast();
            }
        }
        return super.getFluidHandlerCapability(side);
    }

    @Override
    public void readConveyableData(Player player, CompoundTag tag) {
        this.reconfigControl.readSettings(tag);
        this.transferControl.readSettings(tag);
        super.readConveyableData(player, tag);
    }

    @Override
    public void writeConveyableData(Player player, CompoundTag tag) {
        this.reconfigControl.writeSettings(tag);
        this.transferControl.writeSettings(tag);
        super.writeConveyableData(player, tag);
    }
}

