/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.item;

import cofh.core.item.IMultiModeItem;
import cofh.core.item.XpContainerItem;
import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.ChatHelper;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class XpCrystalItem
extends XpContainerItem
implements IMultiModeItem {
    public XpCrystalItem(Item.Properties builder, int xpCapacity) {
        super(builder, xpCapacity);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("stored"), (stack, world, living, seed) -> (float)this.getStoredXp(stack) / (float)this.getCapacityXp(stack));
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)StringHelper.getTextComponent((String)"info.thermal.xp_crystal.use").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)StringHelper.getTextComponent((String)"info.thermal.xp_crystal.use.sneak").m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)StringHelper.getTextComponent((String)("info.thermal.xp_crystal.mode." + this.getMode(stack))).m_130940_(ChatFormatting.ITALIC));
        this.addModeChangeTooltip(this, stack, worldIn, tooltip, flagIn);
        super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (Utils.isClientWorld((Level)worldIn) || Utils.isFakePlayer((Entity)entityIn) || this.getMode(stack) <= 0) {
            return;
        }
        entityIn.getPersistentData().m_128356_("XpTimer", entityIn.f_19853_.m_46467_());
    }

    public boolean canStoreXp(ItemStack stack) {
        return this.getMode(stack) > 0;
    }

    public void onModeChange(Player player, ItemStack stack) {
        player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.4f, 0.6f + 0.2f * (float)this.getMode(stack));
        ChatHelper.sendIndexedChatMessageToPlayer((Player)player, (Component)new TranslatableComponent("info.thermal.xp_crystal.mode." + this.getMode(stack)));
    }
}

