/*
 * Decompiled with CFR 0.152.
 */
package com.curseforge.goblins.init;

import com.curseforge.goblins.world.features.GoblinTentFeature;
import com.curseforge.goblins.world.features.GoblinVillage1Feature;
import com.curseforge.goblins.world.features.GoblinVillage2Feature;
import com.curseforge.goblins.world.features.GoblinVillage3Feature;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class GoblinsModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"goblins");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> GOBLIN_VILLAGE_1 = GoblinsModFeatures.register("goblin_village_1", GoblinVillage1Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, GoblinVillage1Feature.GENERATE_BIOMES, GoblinVillage1Feature::placedFeature));
    public static final RegistryObject<Feature<?>> GOBLIN_VILLAGE_2 = GoblinsModFeatures.register("goblin_village_2", GoblinVillage2Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, GoblinVillage2Feature.GENERATE_BIOMES, GoblinVillage2Feature::placedFeature));
    public static final RegistryObject<Feature<?>> GOBLIN_VILLAGE_3 = GoblinsModFeatures.register("goblin_village_3", GoblinVillage3Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, GoblinVillage3Feature.GENERATE_BIOMES, GoblinVillage3Feature::placedFeature));
    public static final RegistryObject<Feature<?>> GOBLIN_TENT = GoblinsModFeatures.register("goblin_tent", GoblinTentFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, GoblinTentFeature.GENERATE_BIOMES, GoblinTentFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

