/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.screen;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import draylar.identity.Identity;
import draylar.identity.api.PlayerFavorites;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.PlayerUnlocks;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.mixin.accessor.ScreenAccessor;
import draylar.identity.screen.widget.EntityWidget;
import draylar.identity.screen.widget.HelpWidget;
import draylar.identity.screen.widget.PlayerWidget;
import draylar.identity.screen.widget.SearchWidget;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class IdentityScreen
extends Screen {
    private final List<IdentityType<?>> unlocked = new ArrayList();
    private final Map<IdentityType<?>, LivingEntity> renderEntities = new LinkedHashMap();
    private final List<EntityWidget> entityWidgets = new ArrayList<EntityWidget>();
    private final SearchWidget searchBar = this.createSearchBar();
    private final PlayerWidget playerButton = this.createPlayerButton();
    private final Button helpButton = this.createHelpButton();
    private String lastSearchContents = "";

    public IdentityScreen() {
        super((Component)new TextComponent(""));
        super.m_6575_(Minecraft.m_91087_(), Minecraft.m_91087_().m_91268_().m_85445_(), Minecraft.m_91087_().m_91268_().m_85446_());
        if (this.f_96541_.f_91074_ == null) {
            this.f_96541_.m_91152_(null);
            return;
        }
        this.populateRenderEntities();
        this.m_142416_((GuiEventListener)this.searchBar);
        this.m_142416_((GuiEventListener)this.playerButton);
        this.m_142416_((GuiEventListener)this.helpButton);
        this.unlocked.addAll(this.collectUnlockedEntities(this.f_96541_.f_91074_));
        try {
            this.unlocked.sort((first, second) -> {
                if (PlayerFavorites.has((Player)this.f_96541_.f_91074_, first)) {
                    return -1;
                }
                return 1;
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.populateEntityWidgets(this.f_96541_.f_91074_, this.unlocked);
        this.searchBar.m_94151_(text -> {
            this.m_94725_((GuiEventListener)this.searchBar);
            if (!this.lastSearchContents.equals(text)) {
                ((ScreenAccessor)((Object)this)).getSelectables().removeIf(button -> button instanceof EntityWidget);
                this.m_6702_().removeIf(button -> button instanceof EntityWidget);
                this.entityWidgets.clear();
                List<IdentityType<?>> filtered = this.unlocked.stream().filter(type -> text.isEmpty() || type.getEntityType().m_20675_().contains((CharSequence)text)).collect(Collectors.toList());
                this.populateEntityWidgets(this.f_96541_.f_91074_, filtered);
            }
            this.lastSearchContents = text;
        });
    }

    public void m_169413_() {
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        if (this.unlocked.isEmpty()) {
            TranslatableComponent message = new TranslatableComponent("identity.menu_hint");
            float xPosition = (float)this.getWindow().m_85443_() / 2.0f - (float)Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)message) / 2.0f;
            float yPosition = (float)this.getWindow().m_85444_() / 2.0f;
            Minecraft.m_91087_().f_91062_.m_92889_(matrices, (Component)message, xPosition, yPosition, 0xFFFFFF);
        }
        for (NarratableEntry selectable : ((ScreenAccessor)((Object)this)).getSelectables()) {
            AbstractButton button;
            if (!(selectable instanceof AbstractButton) || !(button = (AbstractButton)selectable).m_198029_()) continue;
            button.m_7428_(matrices, mouseX, mouseY);
            break;
        }
        this.searchBar.m_6305_(matrices, mouseX, mouseY, delta);
        this.playerButton.m_6305_(matrices, mouseX, mouseY, delta);
        this.helpButton.m_6305_(matrices, mouseX, mouseY, delta);
        this.renderEntityWidgets(matrices, mouseX, mouseY, delta);
    }

    public void renderEntityWidgets(PoseStack matrices, int mouseX, int mouseY, float delta) {
        double scaledFactor = this.f_96541_.m_91268_().m_85449_();
        int top = 35;
        matrices.m_85836_();
        RenderSystem.m_69488_((int)((int)(0.0 * scaledFactor)), (int)((int)(0.0 * scaledFactor)), (int)((int)((double)this.f_96543_ * scaledFactor)), (int)((int)((double)(this.f_96544_ - top) * scaledFactor)));
        this.entityWidgets.forEach(widget -> widget.m_6305_(matrices, mouseX, mouseY, delta));
        RenderSystem.m_69471_();
        matrices.m_85849_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.entityWidgets.size() > 0) {
            float firstPos = this.entityWidgets.get((int)0).f_93621_;
            if (amount == 1.0 && firstPos >= 35.0f) {
                return false;
            }
            ((ScreenAccessor)((Object)this)).getSelectables().forEach(button -> {
                if (button instanceof EntityWidget) {
                    EntityWidget widget = (EntityWidget)((Object)button);
                    widget.f_93621_ = (int)((double)widget.f_93621_ + amount * 10.0);
                }
            });
        }
        return false;
    }

    private void populateEntityWidgets(LocalPlayer player, List<IdentityType<?>> unlocked) {
        int x = 15;
        int y = 35;
        int rows = (int)Math.ceil((float)unlocked.size() / 7.0f);
        IdentityType<LivingEntity> currentType = IdentityType.from(PlayerIdentity.getIdentity((Player)player));
        for (int yIndex = 0; yIndex <= rows; ++yIndex) {
            for (int xIndex = 0; xIndex < 7; ++xIndex) {
                int listIndex = yIndex * 7 + xIndex;
                if (listIndex >= unlocked.size()) continue;
                IdentityType<?> type = unlocked.get(listIndex);
                boolean isCurrent = false;
                if (currentType != null && currentType.equals(type)) {
                    isCurrent = true;
                }
                EntityWidget<LivingEntity> entityWidget = new EntityWidget<LivingEntity>((float)(this.getWindow().m_85445_() - 27) / 7.0f * (float)xIndex + (float)x, (float)this.getWindow().m_85446_() / 5.0f * (float)yIndex + (float)y, (float)(this.getWindow().m_85445_() - 27) / 7.0f, (float)this.getWindow().m_85446_() / 5.0f, type, this.renderEntities.get(type), this, PlayerFavorites.has((Player)player, type), isCurrent);
                this.m_142416_((GuiEventListener)entityWidget);
                this.entityWidgets.add(entityWidget);
            }
        }
    }

    private void populateRenderEntities() {
        if (this.renderEntities.isEmpty()) {
            List<IdentityType<?>> types = IdentityType.getAllTypes((Level)Minecraft.m_91087_().f_91073_);
            for (IdentityType<?> type : types) {
                Object entity = type.create((Level)Minecraft.m_91087_().f_91073_);
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                this.renderEntities.put(type, living);
            }
            Identity.LOGGER.info(String.format("Loaded %d entities for rendering", types.size()));
        }
    }

    private List<IdentityType<?>> collectUnlockedEntities(LocalPlayer player) {
        ArrayList unlocked = new ArrayList();
        this.renderEntities.forEach((type, instance) -> {
            if (PlayerUnlocks.has((Player)player, type) || player.m_7500_()) {
                unlocked.add((IdentityType<?>)type);
            }
        });
        return unlocked;
    }

    private SearchWidget createSearchBar() {
        return new SearchWidget((float)this.getWindow().m_85445_() / 2.0f - (float)this.getWindow().m_85445_() / 4.0f / 2.0f - 5.0f, 5.0f, (float)this.getWindow().m_85445_() / 4.0f, 20.0f);
    }

    private PlayerWidget createPlayerButton() {
        return new PlayerWidget((float)this.getWindow().m_85445_() / 2.0f + (float)this.getWindow().m_85445_() / 8.0f + 5.0f, 7.0f, 15.0f, 15.0f, this);
    }

    private Button createHelpButton() {
        return new HelpWidget((int)((float)this.getWindow().m_85445_() / 2.0f - (float)this.getWindow().m_85445_() / 4.0f / 2.0f - 5.0f) - 30, 5, 20, 20);
    }

    public Window getWindow() {
        return Minecraft.m_91087_().m_91268_();
    }

    public void disableAll() {
        this.entityWidgets.forEach(button -> button.setActive(false));
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (mouseY < 35.0) {
            return this.searchBar.m_6375_(mouseX, mouseY, button) || this.playerButton.m_6375_(mouseX, mouseY, button) || this.helpButton.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

