/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.mixin.player;

import dev.architectury.event.EventResult;
import draylar.identity.Identity;
import draylar.identity.api.FlightHelper;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.event.IdentitySwapCallback;
import draylar.identity.api.platform.IdentityConfig;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.impl.DimensionsRefresher;
import draylar.identity.impl.PlayerDataProvider;
import draylar.identity.mixin.EntityTrackerAccessor;
import draylar.identity.mixin.ThreadedAnvilChunkStorageAccessor;
import draylar.identity.registry.IdentityEntityTags;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerEntityDataMixin
extends LivingEntity
implements PlayerDataProvider {
    @Unique
    private static final String ABILITY_COOLDOWN_KEY = "AbilityCooldown";
    @Unique
    private final Set<IdentityType<?>> unlocked = new HashSet();
    @Unique
    private final Set<IdentityType<?>> favorites = new HashSet();
    @Unique
    private int remainingTime = 0;
    @Unique
    private int abilityCooldown = 0;
    @Unique
    private LivingEntity identity = null;
    @Unique
    private IdentityType<?> identityType = null;

    @Shadow
    public abstract void m_5496_(SoundEvent var1, float var2, float var3);

    private PlayerEntityDataMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="RETURN")})
    private void readNbt(CompoundTag tag, CallbackInfo info) {
        this.unlocked.clear();
        ListTag unlockedIdList = tag.m_128437_("UnlockedMorphs", 8);
        unlockedIdList.forEach(entityRegistryID -> {
            ResourceLocation id = new ResourceLocation(entityRegistryID.m_7916_());
            if (Registry.f_122826_.m_7804_(id)) {
                EntityType type = (EntityType)Registry.f_122826_.m_7745_(id);
                this.unlocked.add(new IdentityType(type));
            }
        });
        ListTag unlockedIdentityList = tag.m_128437_("UnlockedIdentities", 10);
        unlockedIdentityList.forEach(compound -> {
            IdentityType<?> type = IdentityType.from((CompoundTag)compound);
            if (type != null) {
                this.unlocked.add(type);
            }
        });
        this.favorites.clear();
        ListTag favoriteIdList = tag.m_128437_("FavoriteIdentities", 8);
        favoriteIdList.forEach(registryID -> {
            ResourceLocation id = new ResourceLocation(registryID.m_7916_());
            if (Registry.f_122826_.m_7804_(id)) {
                EntityType type = (EntityType)Registry.f_122826_.m_7745_(id);
                this.favorites.add(new IdentityType(type));
            }
        });
        ListTag favoriteTypeList = tag.m_128437_("FavoriteIdentitiesV2", 8);
        favoriteTypeList.forEach(compound -> {
            IdentityType<?> type = IdentityType.from((CompoundTag)compound);
            if (type != null) {
                this.favorites.add(type);
            }
        });
        this.abilityCooldown = tag.m_128451_(ABILITY_COOLDOWN_KEY);
        this.remainingTime = tag.m_128451_("RemainingHostilityTime");
        this.readCurrentIdentity(tag.m_128469_("CurrentIdentity"));
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="RETURN")})
    private void writeNbt(CompoundTag tag, CallbackInfo info) {
        ListTag idList = new ListTag();
        this.unlocked.forEach(identity -> idList.add((Object)identity.writeCompound()));
        tag.m_128365_("UnlockedIdentities", (Tag)idList);
        idList = new ListTag();
        this.favorites.forEach(entityId -> idList.add((Object)entityId.writeCompound()));
        tag.m_128365_("FavoriteIdentitiesV2", (Tag)idList);
        tag.m_128405_(ABILITY_COOLDOWN_KEY, this.abilityCooldown);
        tag.m_128405_("RemainingHostilityTime", this.remainingTime);
        tag.m_128365_("CurrentIdentity", (Tag)this.writeCurrentIdentity(new CompoundTag()));
    }

    @Unique
    private CompoundTag writeCurrentIdentity(CompoundTag tag) {
        CompoundTag entityTag = new CompoundTag();
        if (this.identity != null) {
            this.identity.m_20240_(entityTag);
            if (this.identityType != null) {
                this.identityType.writeEntityNbt(entityTag);
            }
        }
        tag.m_128359_("id", this.identity == null ? "minecraft:empty" : Registry.f_122826_.m_7981_((Object)this.identity.m_6095_()).toString());
        tag.m_128365_("EntityData", (Tag)entityTag);
        return tag;
    }

    @Unique
    public void readCurrentIdentity(CompoundTag tag) {
        CompoundTag entityTag;
        Optional type = EntityType.m_20637_((CompoundTag)tag);
        if (tag.m_128461_("id").equals("minecraft:empty")) {
            this.identity = null;
            ((DimensionsRefresher)((Object)this)).identity_refreshDimensions();
        } else if (type.isPresent() && (entityTag = tag.m_128469_("EntityData")) != null) {
            if (this.identity == null || !((EntityType)type.get()).equals(this.identity.m_6095_())) {
                this.identity = (LivingEntity)((EntityType)type.get()).m_20615_(this.f_19853_);
                ((DimensionsRefresher)((Object)this)).identity_refreshDimensions();
            }
            this.identity.m_20258_(entityTag);
            this.identityType = IdentityType.fromEntityNbt(tag);
        }
    }

    @Override
    @Unique
    public Set<IdentityType<?>> getUnlocked() {
        return this.unlocked;
    }

    @Override
    public void setUnlocked(Set<IdentityType<?>> unlocked) {
        this.unlocked.clear();
        this.unlocked.addAll(unlocked);
    }

    @Override
    @Unique
    public Set<IdentityType<?>> getFavorites() {
        return this.favorites;
    }

    @Override
    public void setFavorites(Set<IdentityType<?>> favorites) {
        this.favorites.clear();
        this.favorites.addAll(favorites);
    }

    @Override
    @Unique
    public int getRemainingHostilityTime() {
        return this.remainingTime;
    }

    @Override
    @Unique
    public void setRemainingHostilityTime(int max) {
        this.remainingTime = max;
    }

    @Override
    @Unique
    public int getAbilityCooldown() {
        return this.abilityCooldown;
    }

    @Override
    @Unique
    public void setAbilityCooldown(int abilityCooldown) {
        this.abilityCooldown = abilityCooldown;
    }

    @Override
    @Unique
    public LivingEntity getIdentity() {
        return this.identity;
    }

    @Override
    public IdentityType<?> getIdentityType() {
        return this.identityType;
    }

    @Override
    @Unique
    public void setIdentity(LivingEntity identity) {
        this.identity = identity;
    }

    @Override
    @Unique
    public boolean updateIdentity(@Nullable LivingEntity identity) {
        Player player = (Player)this;
        EventResult result = ((IdentitySwapCallback)IdentitySwapCallback.EVENT.invoker()).swap((ServerPlayer)player, identity);
        if (result.isFalse()) {
            return false;
        }
        this.identity = identity;
        ((DimensionsRefresher)player).identity_refreshDimensions();
        if (identity != null && IdentityConfig.getInstance().scalingHealth()) {
            player.m_21153_(Math.min(player.m_21223_(), identity.m_21233_()));
            player.m_21051_(Attributes.f_22276_).m_22100_((double)Math.min((float)IdentityConfig.getInstance().maxHealth(), identity.m_21233_()));
        }
        if (identity == null) {
            player.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            player.m_21153_(Math.min(player.m_21223_(), player.m_21233_()));
        }
        ServerPlayer serverPlayerEntity = (ServerPlayer)player;
        if (Identity.hasFlyingPermissions((ServerPlayer)player)) {
            FlightHelper.grantFlightTo(serverPlayerEntity);
            player.m_150110_().m_35943_(IdentityConfig.getInstance().flySpeed());
            player.m_6885_();
        } else {
            FlightHelper.revokeFlight(serverPlayerEntity);
            player.m_150110_().m_35943_(0.05f);
            player.m_6885_();
        }
        if (player.m_20202_() instanceof Ravager && (identity == null || !identity.m_6095_().m_204039_(IdentityEntityTags.RAVAGER_RIDING))) {
            player.m_8127_();
        }
        if (!player.f_19853_.f_46443_) {
            PlayerIdentity.sync((ServerPlayer)player);
            Int2ObjectMap<Object> trackers = ((ThreadedAnvilChunkStorageAccessor)((ServerLevel)player.f_19853_).m_7726_().f_8325_).getEntityTrackers();
            Object tracking = trackers.get(player.m_142049_());
            ((EntityTrackerAccessor)tracking).getListeners().forEach(listener -> PlayerIdentity.sync((ServerPlayer)player, listener.m_142253_()));
        }
        return true;
    }
}

