/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.mixin;

import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.event.PlayerJoinCallback;
import draylar.identity.api.platform.IdentityConfig;
import draylar.identity.impl.DimensionsRefresher;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerList.class})
public class PlayerManagerMixin {
    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayNetworkHandler;sendPacket(Lnet/minecraft/network/Packet;)V", ordinal=0)}, method={"onPlayerConnect"})
    private void connect(Connection connection, ServerPlayer player, CallbackInfo ci) {
        ((PlayerJoinCallback)PlayerJoinCallback.EVENT.invoker()).onPlayerJoin(player);
    }

    @Inject(method={"respawnPlayer"}, at={@At(value="RETURN")})
    private void onRespawn(ServerPlayer player, boolean alive, CallbackInfoReturnable<ServerPlayer> cir) {
        LivingEntity identity = PlayerIdentity.getIdentity((Player)player);
        ((DimensionsRefresher)player).identity_refreshDimensions();
        if (identity != null && IdentityConfig.getInstance().scalingHealth()) {
            player.m_21153_(Math.min(player.m_21223_(), identity.m_21233_()));
            player.m_21051_(Attributes.f_22276_).m_22100_((double)Math.min((float)IdentityConfig.getInstance().maxHealth(), identity.m_21233_()));
            player.f_8906_.m_141995_((Packet)new ClientboundUpdateAttributesPacket(player.m_142049_(), player.m_21204_().m_22170_()));
        }
    }
}

