/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.mixin;

import draylar.identity.api.PlayerIdentity;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityFoodMixin
extends Entity {
    @Unique
    private static final LazyLoadedValue<List<FoodProperties>> WOLVES_IGNORE = new LazyLoadedValue(() -> Arrays.asList(Foods.f_38817_, Foods.f_38800_, Foods.f_38804_));

    public LivingEntityFoodMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"applyFoodEffects"}, at={@At(value="INVOKE", target="Ljava/util/Iterator;hasNext()Z")}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void removeFleshHungerForWolves(ItemStack stack, Level world, LivingEntity targetEntity, CallbackInfo ci, Item item) {
        Player player;
        LivingEntity identity;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player && (identity = PlayerIdentity.getIdentity(player = (Player)livingEntity)) instanceof Wolf && ((List)WOLVES_IGNORE.m_13971_()).contains(item.m_41473_())) {
            ci.cancel();
        }
    }
}

