/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.forge.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.platform.Platform;
import draylar.identity.forge.config.IdentityForgeConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class ConfigLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static IdentityForgeConfig read() {
        Path configFolder = Platform.getConfigFolder();
        Path configFile = Paths.get(configFolder.toString(), "identity.json");
        if (!Files.exists(configFile, new LinkOption[0])) {
            IdentityForgeConfig config = new IdentityForgeConfig();
            ConfigLoader.writeConfigFile(configFile, config);
            return config;
        }
        try {
            IdentityForgeConfig newConfig = (IdentityForgeConfig)GSON.fromJson(Files.readString(configFile), IdentityForgeConfig.class);
            ConfigLoader.writeConfigFile(configFile, newConfig);
            return newConfig;
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return new IdentityForgeConfig();
        }
    }

    private static void writeConfigFile(Path file, IdentityForgeConfig config) {
        try {
            if (!Files.exists(file, new LinkOption[0])) {
                Files.createFile(file, new FileAttribute[0]);
            }
            Files.writeString(file, (CharSequence)GSON.toJson((Object)config), new OpenOption[0]);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }
}

