/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.PlayerUnlocks;
import draylar.identity.api.platform.IdentityConfig;
import draylar.identity.api.variant.IdentityType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.EntitySummonArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class IdentityCommand {
    public static void register() {
        CommandRegistrationEvent.EVENT.register((dispatcher, b) -> {
            LiteralCommandNode rootNode = ((LiteralArgumentBuilder)Commands.m_82127_((String)"identity").requires(source -> source.m_6761_(2))).build();
            LiteralCommandNode grantNode = ((LiteralArgumentBuilder)Commands.m_82127_((String)"grant").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"everything").executes(context -> {
                ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"player");
                for (IdentityType<?> type : IdentityType.getAllTypes(player.f_19853_)) {
                    if (PlayerUnlocks.has((Player)player, type)) continue;
                    PlayerUnlocks.unlock(player, type);
                }
                return 1;
            }))).then(Commands.m_82129_((String)"identity", (ArgumentType)EntitySummonArgument.m_93335_()).suggests(SuggestionProviders.f_121645_).executes(context -> {
                IdentityCommand.grant(((CommandSourceStack)context.getSource()).m_81375_(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), new IdentityType((EntityType)Registry.f_122826_.m_7745_(EntitySummonArgument.m_93338_((CommandContext)context, (String)"identity"))));
                return 1;
            })))).build();
            LiteralCommandNode revokeNode = ((LiteralArgumentBuilder)Commands.m_82127_((String)"revoke").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"everything").executes(context -> {
                ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"player");
                for (IdentityType<?> type : IdentityType.getAllTypes(player.f_19853_)) {
                    if (PlayerUnlocks.has((Player)player, type)) continue;
                    PlayerUnlocks.revoke(player, type);
                }
                return 1;
            }))).then(Commands.m_82129_((String)"identity", (ArgumentType)EntitySummonArgument.m_93335_()).suggests(SuggestionProviders.f_121645_).executes(context -> {
                IdentityCommand.revoke(((CommandSourceStack)context.getSource()).m_81375_(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), new IdentityType((EntityType)Registry.f_122826_.m_7745_(EntitySummonArgument.m_93338_((CommandContext)context, (String)"identity"))));
                return 1;
            })))).build();
            LiteralCommandNode equip = ((LiteralArgumentBuilder)Commands.m_82127_((String)"equip").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"identity", (ArgumentType)EntitySummonArgument.m_93335_()).suggests(SuggestionProviders.f_121645_).executes(context -> {
                IdentityCommand.equip(((CommandSourceStack)context.getSource()).m_81375_(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), EntitySummonArgument.m_93338_((CommandContext)context, (String)"identity"));
                return 1;
            })))).build();
            LiteralCommandNode unequip = ((LiteralArgumentBuilder)Commands.m_82127_((String)"unequip").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> {
                IdentityCommand.unequip(((CommandSourceStack)context.getSource()).m_81375_(), EntityArgument.m_91474_((CommandContext)context, (String)"player"));
                return 1;
            }))).build();
            LiteralCommandNode test = ((LiteralArgumentBuilder)Commands.m_82127_((String)"test").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"not").then(Commands.m_82129_((String)"identity", (ArgumentType)EntitySummonArgument.m_93335_()).suggests(SuggestionProviders.f_121645_).executes(context -> IdentityCommand.testNot(((CommandSourceStack)context.getSource()).m_81375_(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), EntitySummonArgument.m_93338_((CommandContext)context, (String)"identity")))))).then(Commands.m_82129_((String)"identity", (ArgumentType)EntitySummonArgument.m_93335_()).suggests(SuggestionProviders.f_121645_).executes(context -> IdentityCommand.test(((CommandSourceStack)context.getSource()).m_81375_(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), EntitySummonArgument.m_93338_((CommandContext)context, (String)"identity")))))).build();
            rootNode.addChild((CommandNode)grantNode);
            rootNode.addChild((CommandNode)revokeNode);
            rootNode.addChild((CommandNode)equip);
            rootNode.addChild((CommandNode)unequip);
            rootNode.addChild((CommandNode)test);
            dispatcher.getRoot().addChild((CommandNode)rootNode);
        });
    }

    private static int test(ServerPlayer source, ServerPlayer player, ResourceLocation identity) {
        EntityType type = (EntityType)Registry.f_122826_.m_7745_(identity);
        if (PlayerIdentity.getIdentity((Player)player) != null && PlayerIdentity.getIdentity((Player)player).m_6095_().equals(type)) {
            if (IdentityConfig.getInstance().logCommands()) {
                source.m_5661_((Component)new TranslatableComponent("identity.test_positive", new Object[]{player.m_5446_(), new TranslatableComponent(type.m_20675_())}), true);
            }
            return 1;
        }
        if (IdentityConfig.getInstance().logCommands()) {
            source.m_5661_((Component)new TranslatableComponent("identity.test_failed", new Object[]{player.m_5446_(), new TranslatableComponent(type.m_20675_())}), true);
        }
        return 0;
    }

    private static int testNot(ServerPlayer source, ServerPlayer player, ResourceLocation identity) {
        EntityType type = (EntityType)Registry.f_122826_.m_7745_(identity);
        if (PlayerIdentity.getIdentity((Player)player) != null && !PlayerIdentity.getIdentity((Player)player).m_6095_().equals(type)) {
            if (IdentityConfig.getInstance().logCommands()) {
                source.m_5661_((Component)new TranslatableComponent("identity.test_failed", new Object[]{player.m_5446_(), new TranslatableComponent(type.m_20675_())}), true);
            }
            return 1;
        }
        if (IdentityConfig.getInstance().logCommands()) {
            source.m_5661_((Component)new TranslatableComponent("identity.test_positive", new Object[]{player.m_5446_(), new TranslatableComponent(type.m_20675_())}), true);
        }
        return 0;
    }

    private static void grant(ServerPlayer source, ServerPlayer player, IdentityType<?> type) {
        if (!PlayerUnlocks.has((Player)player, type)) {
            boolean result = PlayerUnlocks.unlock(player, type);
            if (result && IdentityConfig.getInstance().logCommands()) {
                player.m_5661_((Component)new TranslatableComponent("identity.unlock_entity", new Object[]{new TranslatableComponent(type.getEntityType().m_20675_())}), true);
                source.m_5661_((Component)new TranslatableComponent("identity.grant_success", new Object[]{new TranslatableComponent(type.getEntityType().m_20675_()), player.m_5446_()}), true);
            }
        } else if (IdentityConfig.getInstance().logCommands()) {
            source.m_5661_((Component)new TranslatableComponent("identity.already_has", new Object[]{player.m_5446_(), new TranslatableComponent(type.getEntityType().m_20675_())}), true);
        }
    }

    private static void revoke(ServerPlayer source, ServerPlayer player, IdentityType<?> type) {
        if (PlayerUnlocks.has((Player)player, type)) {
            PlayerUnlocks.revoke(player, type);
            if (IdentityConfig.getInstance().logCommands()) {
                player.m_5661_((Component)new TranslatableComponent("identity.revoke_entity", new Object[]{new TranslatableComponent(type.getEntityType().m_20675_())}), true);
                source.m_5661_((Component)new TranslatableComponent("identity.revoke_success", new Object[]{new TranslatableComponent(type.getEntityType().m_20675_()), player.m_5446_()}), true);
            }
        } else if (IdentityConfig.getInstance().logCommands()) {
            source.m_5661_((Component)new TranslatableComponent("identity.does_not_have", new Object[]{player.m_5446_(), new TranslatableComponent(type.getEntityType().m_20675_())}), true);
        }
    }

    private static void equip(ServerPlayer source, ServerPlayer player, ResourceLocation identity) {
        boolean result;
        LivingEntity living;
        IdentityType<LivingEntity> defaultType;
        EntityType entity = (EntityType)Registry.f_122826_.m_7745_(identity);
        Entity createdEntity = entity.m_20615_(player.f_19853_);
        if (createdEntity instanceof LivingEntity && (defaultType = IdentityType.from(living = (LivingEntity)createdEntity)) != null && (result = PlayerIdentity.updateIdentity(player, defaultType, (LivingEntity)createdEntity)) && IdentityConfig.getInstance().logCommands()) {
            source.m_5661_((Component)new TranslatableComponent("identity.equip_success", new Object[]{new TranslatableComponent(entity.m_20675_()), player.m_5446_()}), true);
        }
    }

    private static void unequip(ServerPlayer source, ServerPlayer player) {
        boolean result = PlayerIdentity.updateIdentity(player, null, null);
        if (result && IdentityConfig.getInstance().logCommands()) {
            source.m_5661_((Component)new TranslatableComponent("identity.unequip_success", new Object[]{player.m_5446_()}), false);
        }
    }
}

