/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.api.model;

import draylar.identity.api.model.EntityUpdater;
import draylar.identity.impl.NearbySongAccessor;
import draylar.identity.mixin.accessor.CreeperEntityAccessor;
import draylar.identity.mixin.accessor.ParrotEntityAccessor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EntityUpdaters {
    private static final Map<EntityType<? extends LivingEntity>, EntityUpdater<? extends LivingEntity>> map = new HashMap<EntityType<? extends LivingEntity>, EntityUpdater<? extends LivingEntity>>();

    public static <T extends LivingEntity> EntityUpdater<T> getUpdater(EntityType<T> entityType) {
        return map.getOrDefault(entityType, null);
    }

    public static <T extends LivingEntity> void register(EntityType<T> type, EntityUpdater<T> entityUpdater) {
        map.put(type, entityUpdater);
    }

    private EntityUpdaters() {
    }

    public static void init() {
        EntityUpdaters.register(EntityType.f_20549_, (player, bat) -> {
            if (player.m_20096_()) {
                bat.m_27456_(true);
            } else {
                bat.m_27456_(false);
            }
        });
        EntityUpdaters.register(EntityType.f_20508_, (player, parrot) -> {
            if (player.m_20096_() && ((NearbySongAccessor)player).identity_isNearbySongPlaying()) {
                parrot.m_6818_(player.m_142538_(), true);
                parrot.m_21839_(true);
                parrot.m_6853_(true);
            } else if (player.m_20096_()) {
                parrot.m_6818_(player.m_142538_(), false);
                parrot.m_21839_(true);
                parrot.m_6853_(true);
                parrot.f_29353_ = 0.0f;
                parrot.f_29350_ = 0.0f;
                parrot.f_29351_ = 0.0f;
                parrot.f_29352_ = 0.0f;
            } else {
                parrot.m_6818_(player.m_142538_(), false);
                parrot.m_21839_(false);
                parrot.m_6853_(false);
                parrot.m_21837_(false);
                ((ParrotEntityAccessor)parrot).callFlapWings();
            }
        });
        EntityUpdaters.register(EntityType.f_20565_, (player, dragon) -> {
            dragon.f_31082_ += 0.01f;
            dragon.f_31081_ = dragon.f_31082_;
            if (dragon.f_31093_ < 0) {
                for (int l = 0; l < dragon.f_31092_.length; ++l) {
                    dragon.f_31092_[l][0] = (double)player.m_146908_() + 180.0;
                    dragon.f_31092_[l][1] = player.m_20186_();
                }
            }
            if (++dragon.f_31093_ == dragon.f_31092_.length) {
                dragon.f_31093_ = 0;
            }
            dragon.f_31092_[dragon.f_31093_][0] = (double)player.m_146908_() + 180.0;
            dragon.f_31092_[dragon.f_31093_][1] = player.m_20186_();
        });
        EntityUpdaters.register(EntityType.f_20566_, (player, enderman) -> {
            ItemStack heldStack = player.m_21205_();
            if (heldStack.m_41720_() instanceof BlockItem) {
                enderman.m_32521_(((BlockItem)heldStack.m_41720_()).m_40614_().m_49966_());
            }
        });
        EntityUpdaters.register(EntityType.f_20558_, (player, creeper) -> ((CreeperEntityAccessor)creeper).setCurrentFuseTime(0));
    }
}

