/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.api.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import draylar.identity.api.model.ArmRenderingManipulator;
import draylar.identity.api.model.ClassArmProvider;
import draylar.identity.api.model.EntityArmProvider;
import draylar.identity.mixin.accessor.BlazeEntityModelAccessor;
import draylar.identity.mixin.accessor.IllagerEntityModelAccessor;
import draylar.identity.mixin.accessor.LlamaEntityModelAccessor;
import draylar.identity.mixin.accessor.OcelotEntityModelAccessor;
import draylar.identity.mixin.accessor.QuadrupedEntityModelAccessor;
import draylar.identity.mixin.accessor.RavagerEntityModelAccessor;
import draylar.identity.mixin.accessor.SpiderEntityModelAccessor;
import draylar.identity.mixin.accessor.SquidEntityModelAccessor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.model.BlazeModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.IronGolemModel;
import net.minecraft.client.model.LlamaModel;
import net.minecraft.client.model.OcelotModel;
import net.minecraft.client.model.PandaModel;
import net.minecraft.client.model.PigModel;
import net.minecraft.client.model.PolarBearModel;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.RavagerModel;
import net.minecraft.client.model.SpiderModel;
import net.minecraft.client.model.SquidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class EntityArms {
    private static final Map<EntityType<? extends LivingEntity>, Tuple<EntityArmProvider<? extends LivingEntity>, ArmRenderingManipulator<?>>> DIRECT_PROVIDERS = new LinkedHashMap();
    private static final Map<Class<?>, Tuple<ClassArmProvider<?>, ArmRenderingManipulator<?>>> CLASS_PROVIDERS = new LinkedHashMap();

    public static <T extends LivingEntity> void register(EntityType<T> type, EntityArmProvider<T> provider, ArmRenderingManipulator<EntityModel<T>> manipulator) {
        DIRECT_PROVIDERS.put(type, new Tuple(provider, manipulator));
    }

    public static <T> void register(Class<T> modelClass, ClassArmProvider<T> provider, ArmRenderingManipulator<T> manipulator) {
        CLASS_PROVIDERS.put(modelClass, new Tuple(provider, manipulator));
    }

    @Nullable
    public static <T extends LivingEntity> Tuple<ModelPart, ArmRenderingManipulator<?>> get(T entity, EntityModel<T> model) {
        Tuple<EntityArmProvider<? extends LivingEntity>, ArmRenderingManipulator<?>> before = DIRECT_PROVIDERS.get(entity.m_6095_());
        if (before != null) {
            Tuple provider = new Tuple((Object)((EntityArmProvider)before.m_14418_()), (Object)((ArmRenderingManipulator)before.m_14419_()));
            return new Tuple((Object)((EntityArmProvider)provider.m_14418_()).getArm(entity, model), (Object)((ArmRenderingManipulator)provider.m_14419_()));
        }
        Optional<Tuple> beforeClassProvider = CLASS_PROVIDERS.entrySet().stream().filter(pair -> ((Class)pair.getKey()).isInstance(model)).findFirst().map(entry -> new Tuple((Object)((ClassArmProvider)((Tuple)entry.getValue()).m_14418_()), (Object)((ArmRenderingManipulator)((Tuple)entry.getValue()).m_14419_())));
        if (beforeClassProvider.isPresent()) {
            Tuple classProvider = new Tuple((Object)((ClassArmProvider)beforeClassProvider.get().m_14418_()), (Object)((ArmRenderingManipulator)beforeClassProvider.get().m_14419_()));
            return new Tuple((Object)((ClassArmProvider)classProvider.m_14418_()).getArm(entity, model), (Object)((ArmRenderingManipulator)classProvider.m_14419_()));
        }
        return null;
    }

    @Nullable
    public static <T extends LivingEntity> EntityArmProvider<T> get(EntityType<LivingEntity> type) {
        return (EntityArmProvider)DIRECT_PROVIDERS.get(type);
    }

    @Nullable
    public static <T extends LivingEntity> EntityArmProvider<T> get(Class<EntityModel<? extends LivingEntity>> modelClass) {
        return (EntityArmProvider)CLASS_PROVIDERS.get(modelClass);
    }

    public static void init() {
        EntityArms.register(LlamaModel.class, (LivingEntity llama, T model) -> ((LlamaEntityModelAccessor)model).getRightFrontLeg(), (PoseStack stack, T model) -> {});
        EntityArms.register(PandaModel.class, (LivingEntity llama, T model) -> ((QuadrupedEntityModelAccessor)model).getRightFrontLeg(), (PoseStack stack, T model) -> stack.m_85837_(0.0, -0.5, 0.0));
        EntityArms.register(BlazeModel.class, (LivingEntity llama, T model) -> ((BlazeEntityModelAccessor)model).getRods()[10], (PoseStack stack, T model) -> {
            stack.m_85845_(Vector3f.f_122227_.m_122240_(45.0f));
            stack.m_85845_(Vector3f.f_122225_.m_122240_(-15.0f));
            stack.m_85845_(Vector3f.f_122223_.m_122240_(-25.0f));
            stack.m_85837_(0.0, 0.0, -0.25);
        });
        EntityArms.register(OcelotModel.class, (LivingEntity ocelot, T model) -> ((OcelotEntityModelAccessor)model).getRightFrontLeg(), (PoseStack stack, T model) -> {});
        EntityArms.register(SpiderModel.class, (LivingEntity spider, T model) -> ((SpiderEntityModelAccessor)model).getRightFrontLeg(), (PoseStack stack, T model) -> {
            stack.m_85845_(Vector3f.f_122225_.m_122240_(-15.0f));
            stack.m_85845_(Vector3f.f_122223_.m_122240_(15.0f));
            stack.m_85837_(0.0, 0.0, 0.0);
        });
        EntityArms.register(IronGolemModel.class, (LivingEntity golem, T model) -> model.m_102968_(), (PoseStack stack, T model) -> stack.m_85837_(0.0, 0.0, -0.5));
        EntityArms.register(PigModel.class, (LivingEntity pig, T model) -> ((QuadrupedEntityModelAccessor)model).getRightFrontLeg(), (PoseStack stack, T model) -> stack.m_85837_(0.0, 0.0, 0.6));
        EntityArms.register(PolarBearModel.class, (LivingEntity bear, T model) -> ((QuadrupedEntityModelAccessor)model).getRightFrontLeg(), (PoseStack stack, T model) -> stack.m_85837_(0.0, 0.0, 0.3));
        EntityArms.register(RavagerModel.class, (LivingEntity bear, T model) -> ((RavagerEntityModelAccessor)model).getRightFrontLeg(), (PoseStack stack, T model) -> {});
        EntityArms.register(SquidModel.class, (LivingEntity squid, T model) -> ((SquidEntityModelAccessor)model).getTentacles()[0], (PoseStack stack, T model) -> {});
        EntityArms.register(QuadrupedModel.class, (LivingEntity quad, T model) -> ((QuadrupedEntityModelAccessor)model).getRightFrontLeg(), (PoseStack stack, T model) -> {});
        EntityArms.register(EntityType.f_20513_, (T pillager, EntityModel<T> model) -> ((IllagerEntityModelAccessor)model).getRightArm(), (PoseStack stack, EntityModel<T> model) -> {
            stack.m_85845_(Vector3f.f_122223_.m_122240_(-10.0f));
            stack.m_85837_(0.0, 0.5, -0.3);
        });
    }

    private EntityArms() {
    }
}

