/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.api;

import dev.architectury.event.EventResult;
import draylar.identity.api.PlayerAbilities;
import draylar.identity.api.event.UnlockIdentityCallback;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.impl.PlayerDataProvider;
import draylar.identity.network.impl.UnlockPackets;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;

public class PlayerUnlocks {
    public static boolean unlock(ServerPlayer player, IdentityType granted) {
        PlayerDataProvider provider = (PlayerDataProvider)player;
        EventResult unlock = ((UnlockIdentityCallback)UnlockIdentityCallback.EVENT.invoker()).unlock(player, granted);
        if (unlock.asMinecraft() != InteractionResult.FAIL && !provider.getUnlocked().contains(granted)) {
            provider.getUnlocked().add(granted);
            PlayerUnlocks.sync(player);
            PlayerAbilities.sync(player);
            return true;
        }
        return false;
    }

    public static boolean has(Player player, IdentityType type) {
        return type.getEntityType().equals((Object)EntityType.f_20532_) || ((PlayerDataProvider)player).getUnlocked().contains(type);
    }

    public static void revoke(ServerPlayer player, IdentityType type) {
        PlayerDataProvider provider = (PlayerDataProvider)player;
        if (provider.getUnlocked().contains(type)) {
            provider.getUnlocked().remove(type);
            PlayerUnlocks.sync(player);
            PlayerAbilities.sync(player);
        }
    }

    public static void sync(ServerPlayer player) {
        UnlockPackets.sendSyncPacket(player);
    }
}

