/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.api;

import dev.architectury.networking.NetworkManager;
import draylar.identity.impl.PlayerDataProvider;
import draylar.identity.network.NetworkHandler;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PlayerAbilities {
    public static int getCooldown(Player player) {
        return ((PlayerDataProvider)player).getAbilityCooldown();
    }

    public static boolean canUseAbility(Player player) {
        return ((PlayerDataProvider)player).getAbilityCooldown() <= 0;
    }

    public static void setCooldown(Player player, int cooldown) {
        ((PlayerDataProvider)player).setAbilityCooldown(cooldown);
    }

    public static void sync(ServerPlayer player) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeInt(((PlayerDataProvider)player).getAbilityCooldown());
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)NetworkHandler.ABILITY_SYNC, (FriendlyByteBuf)packet);
    }
}

