/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity;

import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import draylar.identity.ability.AbilityRegistry;
import draylar.identity.api.PlayerFavorites;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.PlayerUnlocks;
import draylar.identity.api.platform.IdentityConfig;
import draylar.identity.network.NetworkHandler;
import draylar.identity.network.ServerNetworking;
import draylar.identity.registry.IdentityCommands;
import draylar.identity.registry.IdentityEntityTags;
import draylar.identity.registry.IdentityEventHandlers;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Identity {
    public static final Logger LOGGER = LoggerFactory.getLogger(Identity.class);

    public void initialize() {
        IdentityEntityTags.init();
        AbilityRegistry.init();
        IdentityEventHandlers.registerHostilityUpdateHandler();
        IdentityEventHandlers.registerRavagerRidingHandler();
        IdentityCommands.init();
        ServerNetworking.initialize();
        ServerNetworking.registerUseAbilityPacketHandler();
        Identity.registerJoinSyncPacket();
    }

    public static void registerJoinSyncPacket() {
        PlayerEvent.PLAYER_JOIN.register(player -> {
            FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
            packet.writeBoolean(IdentityConfig.getInstance().enableClientSwapMenu());
            packet.writeBoolean(IdentityConfig.getInstance().showPlayerNametag());
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)NetworkHandler.CONFIG_SYNC, (FriendlyByteBuf)packet);
            PlayerUnlocks.sync(player);
            PlayerFavorites.sync(player);
        });
    }

    public static ResourceLocation id(String name) {
        return new ResourceLocation("identity", name);
    }

    public static boolean hasFlyingPermissions(ServerPlayer player) {
        LivingEntity identity = PlayerIdentity.getIdentity((Player)player);
        if (identity != null && IdentityConfig.getInstance().enableFlight() && identity.m_6095_().m_204039_(IdentityEntityTags.FLYING)) {
            List<String> requiredAdvancements = IdentityConfig.getInstance().advancementsRequiredForFlight();
            if (!requiredAdvancements.isEmpty()) {
                boolean hasPermission = true;
                for (String requiredAdvancement : requiredAdvancements) {
                    Advancement advancement = player.f_8924_.m_129889_().m_136041_(new ResourceLocation(requiredAdvancement));
                    AdvancementProgress progress = player.m_8960_().m_135996_(advancement);
                    if (progress.m_8193_()) continue;
                    hasPermission = false;
                }
                return hasPermission;
            }
            return true;
        }
        return false;
    }

    public static boolean isAquatic(LivingEntity entity) {
        return entity instanceof WaterAnimal || entity instanceof Guardian;
    }

    public static int getCooldown(EntityType<?> type) {
        String id = Registry.f_122826_.m_7981_(type).toString();
        return IdentityConfig.getInstance().getAbilityCooldownMap().getOrDefault(id, 20);
    }
}

