/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.tooltip;

import com.majruszsaccessories.AccessoryHolder;
import com.majruszsaccessories.boosters.BoosterItem;
import com.majruszsaccessories.tooltip.ITooltipProvider;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IntegerConfig;
import com.mlib.text.TextHelper;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;

public class TooltipHelper {
    public static final ChatFormatting DEFAULT_FORMAT = ChatFormatting.GRAY;

    public static MutableComponent asFormula(Object obj1, Object obj2) {
        return new TranslatableComponent("majruszsaccessories.items.formula", new Object[]{obj1, obj2}).m_130940_(DEFAULT_FORMAT);
    }

    public static ITooltipProvider asValue(final IntegerConfig config, final int multiplier) {
        return new ITooltipProvider(){

            @Override
            public MutableComponent getTooltip(AccessoryHolder holder) {
                int bonusValue = holder.apply(config, multiplier);
                int defaultValue = (Integer)config.get();
                int diff = bonusValue - defaultValue;
                return new TextComponent(String.format("%d", bonusValue)).m_130940_(diff != 0 ? holder.getBonusFormatting() : DEFAULT_FORMAT);
            }

            @Override
            public MutableComponent getDetailedTooltip(AccessoryHolder holder) {
                int defaultValue;
                int bonusValue = holder.apply(config, multiplier);
                int diff = bonusValue - (defaultValue = ((Integer)config.get()).intValue());
                TextComponent component = diff != 0 ? new TextComponent(TextHelper.signed((int)diff)) : new TextComponent("");
                return TooltipHelper.asFormula(defaultValue, component.m_130940_(holder.getBonusFormatting()));
            }
        };
    }

    public static ITooltipProvider asValue(IntegerConfig config) {
        return TooltipHelper.asValue(config, 1);
    }

    public static ITooltipProvider asFixedValue(IntegerConfig config) {
        return TooltipHelper.asValue(config, 0);
    }

    public static ITooltipProvider asPercent(final DoubleConfig config, final double multiplier) {
        return new ITooltipProvider(){

            @Override
            public MutableComponent getTooltip(AccessoryHolder holder) {
                float bonusValue = holder.apply(config, multiplier);
                float defaultValue = config.asFloat();
                float diff = bonusValue - defaultValue;
                return new TextComponent(TextHelper.percent((float)bonusValue)).m_130940_(Math.abs(diff) >= 1.0E-4f ? holder.getBonusFormatting() : DEFAULT_FORMAT);
            }

            @Override
            public MutableComponent getDetailedTooltip(AccessoryHolder holder) {
                float defaultValue;
                float bonusValue = holder.apply(config, multiplier);
                float diff = bonusValue - (defaultValue = config.asFloat());
                TextComponent component = Math.abs(diff) >= 1.0E-4f ? new TextComponent(TextHelper.signedPercent((float)diff)) : new TextComponent("");
                return TooltipHelper.asFormula(TextHelper.percent((float)defaultValue), component.m_130940_(holder.getBonusFormatting()));
            }
        };
    }

    public static ITooltipProvider asPercent(DoubleConfig config) {
        return TooltipHelper.asPercent(config, 1.0);
    }

    public static ITooltipProvider asFixedPercent(DoubleConfig config) {
        return TooltipHelper.asPercent(config, 0.0);
    }

    public static ITooltipProvider asItem(final Supplier<BoosterItem> item) {
        return new ITooltipProvider(){

            @Override
            public MutableComponent getTooltip(AccessoryHolder holder) {
                if (!holder.isValid()) {
                    return new TextComponent("");
                }
                return new TranslatableComponent("majruszsaccessories.items.booster_name", new Object[]{((BoosterItem)((Object)item.get())).m_41466_()}).m_130938_(((BoosterItem)((Object)item.get())).m_41460_(ItemStack.f_41583_).getStyleModifier()).m_130946_(" ");
            }
        };
    }
}

