/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.recipes;

import com.majruszsaccessories.AccessoryHolder;
import com.majruszsaccessories.accessories.AccessoryItem;
import com.majruszsaccessories.boosters.BoosterItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record RecipeData(List<AccessoryHolder> accessories, List<BoosterItem> boosters) {
    public RecipeData() {
        this(new ArrayList<AccessoryHolder>(), new ArrayList<BoosterItem>());
    }

    public static RecipeData build(CraftingContainer container) {
        RecipeData data = new RecipeData();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemStack = container.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            if (itemStack.m_41720_() instanceof AccessoryItem) {
                data.accessories.add(AccessoryHolder.create(itemStack));
                continue;
            }
            Item item = itemStack.m_41720_();
            if (item instanceof BoosterItem) {
                BoosterItem item2 = (BoosterItem)item;
                data.boosters.add(item2);
                continue;
            }
            return new RecipeData();
        }
        data.accessories.sort((left, right) -> Float.compare(left.getBonus(), right.getBonus()));
        return data;
    }

    public AccessoryHolder getAccessory(int idx) {
        return this.accessories.get(idx);
    }

    public BoosterItem getBooster(int idx) {
        return this.boosters.get(idx);
    }

    float getStandardDeviation() {
        float average = this.getAverageBonus();
        double variation = this.accessories.stream().map(AccessoryHolder::getBonus).reduce(Float.valueOf(0.0f), (sum, bonus) -> Float.valueOf(sum.floatValue() + (float)Math.pow(bonus.floatValue() - average, 2.0))).floatValue() / (float)this.accessories.size();
        return (float)Math.sqrt(variation);
    }

    float getMaxBonus() {
        return this.accessories.get(this.accessories.size() - 1).getBonus();
    }

    float getMinBonus() {
        return this.accessories.get(0).getBonus();
    }

    float getAverageBonus() {
        return this.accessories.stream().map(AccessoryHolder::getBonus).reduce(Float.valueOf(0.0f), Float::sum).floatValue() / (float)this.accessories.size();
    }

    int getAccessoriesSize() {
        return this.accessories.size();
    }

    int getBoostersSize() {
        return this.boosters.size();
    }

    boolean hasAccessory(AccessoryItem item) {
        return this.accessories.stream().anyMatch(holder -> ((Object)((Object)holder.getItem())).equals((Object)item));
    }

    boolean hasIdenticalItemTypes() {
        return this.accessories.stream().allMatch(holder -> ((Object)((Object)holder.getItem())).equals((Object)this.accessories.get(0).getItem()));
    }
}

