/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.recipes;

import com.majruszsaccessories.AccessoryHolder;
import com.majruszsaccessories.Registries;
import com.majruszsaccessories.boosters.BoosterItem;
import com.majruszsaccessories.recipes.RecipeData;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;

public class BoostAccessoriesRecipe
extends CustomRecipe {
    public static Supplier<RecipeSerializer<?>> create() {
        return () -> new SimpleRecipeSerializer(BoostAccessoriesRecipe::new);
    }

    public BoostAccessoriesRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer container, Level level) {
        RecipeData data = RecipeData.build(container);
        return data.getAccessoriesSize() == 1 && data.getBoostersSize() == 1;
    }

    public ItemStack assemble(CraftingContainer container) {
        RecipeData data = RecipeData.build(container);
        AccessoryHolder holder = data.getAccessory(0);
        BoosterItem booster = data.getBooster(0);
        return holder.copy().setBooster(booster).getItemStack();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Registries.BOOST_ACCESSORIES_RECIPE.get();
    }
}

