/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.majruszsaccessories.AccessoryHolder;
import com.majruszsaccessories.Registries;
import com.majruszsaccessories.accessories.AccessoryItem;
import com.majruszsaccessories.recipes.RecipeData;
import com.mlib.math.Range;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AccessoryRecipe
extends CustomRecipe {
    final AccessoryItem result;
    final List<AccessoryItem> ingredients;

    public static Supplier<RecipeSerializer<?>> create() {
        return Serializer::new;
    }

    public AccessoryRecipe(ResourceLocation id, AccessoryItem result, List<AccessoryItem> ingredients) {
        super(id);
        this.result = result;
        this.ingredients = ingredients;
    }

    public boolean matches(CraftingContainer container, Level level) {
        RecipeData data = RecipeData.build(container);
        return this.ingredients.stream().allMatch(data::hasAccessory);
    }

    public ItemStack assemble(CraftingContainer container) {
        RecipeData data = RecipeData.build(container);
        float average = data.getAverageBonus();
        float std = data.getStandardDeviation();
        float minBonus = ((Float)AccessoryHolder.BONUS_RANGE.clamp((Number)Float.valueOf(average - std))).floatValue();
        float maxBonus = ((Float)AccessoryHolder.BONUS_RANGE.clamp((Number)Float.valueOf(average + std))).floatValue();
        return AccessoryHolder.create(this.result).setBonus((Range<Float>)new Range((Number)Float.valueOf(minBonus), (Number)Float.valueOf(maxBonus))).getItemStack();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Registries.ACCESSORY_RECIPE.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<AccessoryRecipe> {
        public AccessoryRecipe fromJson(ResourceLocation id, JsonObject object) {
            AccessoryItem result = (AccessoryItem)GsonHelper.m_13909_((JsonObject)object, (String)"result");
            List<AccessoryItem> ingredients = Serializer.serializeIngredients(GsonHelper.m_13933_((JsonObject)object, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for accessory recipe");
            }
            return new AccessoryRecipe(id, result, ingredients);
        }

        public AccessoryRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            ArrayList<AccessoryItem> ingredients = new ArrayList<AccessoryItem>();
            for (int idx = 0; idx < size; ++idx) {
                ingredients.add((AccessoryItem)buffer.m_130267_().m_41720_());
            }
            AccessoryItem result = (AccessoryItem)buffer.m_130267_().m_41720_();
            return new AccessoryRecipe(id, result, ingredients);
        }

        public void toNetwork(FriendlyByteBuf buffer, AccessoryRecipe recipe) {
            buffer.m_130130_(recipe.ingredients.size());
            recipe.ingredients.forEach(ingredient -> buffer.m_130055_(new ItemStack((ItemLike)ingredient)));
            buffer.m_130055_(new ItemStack((ItemLike)recipe.result));
        }

        private static List<AccessoryItem> serializeIngredients(JsonArray array) {
            ArrayList<AccessoryItem> ingredients = new ArrayList<AccessoryItem>();
            for (int i = 0; i < array.size(); ++i) {
                ingredients.add((AccessoryItem)GsonHelper.m_13874_((JsonElement)array.get(i), (String)"item"));
            }
            return ingredients;
        }
    }
}

