/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.gamemodifiers.list;

import com.majruszsaccessories.AccessoryHolder;
import com.majruszsaccessories.Integration;
import com.majruszsaccessories.accessories.AccessoryItem;
import com.majruszsaccessories.gamemodifiers.contexts.OnAccessoryTooltip;
import com.mlib.Utility;
import com.mlib.contexts.OnItemTooltip;
import com.mlib.contexts.base.Condition;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import com.mlib.text.TextHelper;
import com.mlib.time.TimeHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

@AutoInstance
public class AccessoryTooltipUpdater {
    static final int PAGE_SIZE = 7;

    public AccessoryTooltipUpdater() {
        OnItemTooltip.listen(this::addTooltip).addCondition(Condition.predicate(data -> data.itemStack.m_41720_() instanceof AccessoryItem));
    }

    private void addTooltip(OnItemTooltip.Data data) {
        AccessoryHolder holder = AccessoryHolder.create(data.itemStack);
        ArrayList<Component> components = new ArrayList<Component>();
        if (holder.hasBonusRangeTag() && !holder.hasBonusTag()) {
            components.addAll(this.buildBonusRangeInfo(data));
        } else {
            components.addAll(this.buildBonusInfo(data));
            components.addAll(this.buildUseInfo(data));
            components.addAll(this.buildEffectsInfo(data));
        }
        data.tooltip.addAll(1, components);
    }

    private List<Component> buildBonusRangeInfo(OnItemTooltip.Data data) {
        Range<Float> range = AccessoryHolder.create(data.itemStack).getBonusRange();
        MutableComponent min = new TextComponent(TextHelper.signedPercent((float)((Float)range.from).floatValue())).m_130940_(AccessoryHolder.getBonusFormatting(((Float)range.from).floatValue()));
        MutableComponent max = new TextComponent(TextHelper.signedPercent((float)((Float)range.to).floatValue())).m_130940_(AccessoryHolder.getBonusFormatting(((Float)range.to).floatValue()));
        return List.of(new TranslatableComponent("majruszsaccessories.items.bonus_range", new Object[]{min, max}).m_130940_(ChatFormatting.GRAY));
    }

    private List<Component> buildBonusInfo(OnItemTooltip.Data data) {
        AccessoryHolder handler = AccessoryHolder.create(data.itemStack);
        float bonus = handler.getBonus();
        if (bonus == 0.0f) {
            return List.of();
        }
        return List.of(new TranslatableComponent("majruszsaccessories.items.bonus", new Object[]{TextHelper.signedPercent((float)bonus)}).m_130940_(handler.getBonusFormatting()));
    }

    private List<Component> buildUseInfo(OnItemTooltip.Data data) {
        if (Integration.isCuriosInstalled()) {
            return List.of();
        }
        return List.of(new TranslatableComponent("majruszsaccessories.items.accessory_item").m_130940_(this.getUseFormatting(data)));
    }

    private ChatFormatting getUseFormatting(OnItemTooltip.Data data) {
        AccessoryHolder handler = AccessoryHolder.create(data.itemStack);
        Player player = data.event.getPlayer();
        if (player != null && AccessoryHolder.find((LivingEntity)player, handler.getItem()).getItemStack() == data.itemStack) {
            return ChatFormatting.GOLD;
        }
        return ChatFormatting.DARK_GRAY;
    }

    private List<Component> buildEffectsInfo(OnItemTooltip.Data data) {
        boolean cannotFitSinglePage;
        OnAccessoryTooltip.Data tooltipData = OnAccessoryTooltip.dispatch(data.itemStack);
        boolean bl = cannotFitSinglePage = tooltipData.components.size() > 7;
        if (cannotFitSinglePage) {
            return this.convertToEffectsInfoPage(tooltipData.components);
        }
        return tooltipData.components;
    }

    private List<Component> convertToEffectsInfoPage(List<Component> components) {
        int totalPages = (int)Math.ceil((double)components.size() / 7.0);
        int currentPage = (int)(Math.floor((double)TimeHelper.getClientTicks() / (double)Utility.secondsToTicks((double)14.0)) % (double)totalPages);
        ArrayList<Component> pageComponents = new ArrayList<Component>(components.subList(currentPage * 7, Math.min((currentPage + 1) * 7, components.size())));
        pageComponents.add((Component)new TranslatableComponent("majruszsaccessories.items.page", new Object[]{currentPage + 1, totalPages}).m_130940_(ChatFormatting.DARK_GRAY));
        return pageComponents;
    }

    static final class Tooltips {
        static final String INVENTORY = "majruszsaccessories.items.accessory_item";
        static final String BONUS = "majruszsaccessories.items.bonus";
        static final String BONUS_RANGE = "majruszsaccessories.items.bonus_range";
        static final String PAGE = "majruszsaccessories.items.page";

        Tooltips() {
        }
    }
}

